/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.yaml;

import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.snakeyaml.composer.Composer;
import io.jenkins.plugins.casc.snakeyaml.nodes.MappingNode;
import io.jenkins.plugins.casc.snakeyaml.nodes.Node;
import io.jenkins.plugins.casc.snakeyaml.nodes.NodeId;
import io.jenkins.plugins.casc.snakeyaml.nodes.NodeTuple;
import io.jenkins.plugins.casc.snakeyaml.nodes.ScalarNode;
import io.jenkins.plugins.casc.snakeyaml.nodes.SequenceNode;
import io.jenkins.plugins.casc.snakeyaml.parser.Parser;
import io.jenkins.plugins.casc.snakeyaml.parser.ParserImpl;
import io.jenkins.plugins.casc.snakeyaml.reader.StreamReader;
import io.jenkins.plugins.casc.snakeyaml.resolver.Resolver;
import io.jenkins.plugins.casc.yaml.ModelConstructor;
import io.jenkins.plugins.casc.yaml.StreamReaderWithSource;
import io.jenkins.plugins.casc.yaml.YamlSource;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public final class YamlUtils {
    public static final Logger LOGGER = Logger.getLogger(ConfigurationAsCode.class.getName());

    public static Node merge(List<YamlSource> configs) throws ConfiguratorException {
        Node root = null;
        for (YamlSource source : configs) {
            try {
                Reader r = source.read();
                Throwable throwable = null;
                try {
                    Node node = YamlUtils.read(source);
                    if (root == null) {
                        root = node;
                        continue;
                    }
                    YamlUtils.merge(root, node, source.toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r == null) continue;
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    r.close();
                }
            }
            catch (IOException io) {
                throw new ConfiguratorException("Failed to read " + source, io);
            }
        }
        return root;
    }

    public static Node read(YamlSource source) throws IOException {
        Composer composer = new Composer((Parser)new ParserImpl((StreamReader)new StreamReaderWithSource(source)), new Resolver());
        return composer.getSingleNode();
    }

    private static void merge(Node root, Node node, String source) throws ConfiguratorException {
        if (root.getNodeId() != node.getNodeId()) {
            throw new ConfiguratorException(String.format("Found incompatible configuration elements %s %s", source, node.getStartMark()));
        }
        switch (root.getNodeId()) {
            case sequence: {
                SequenceNode seq = (SequenceNode)root;
                SequenceNode seq2 = (SequenceNode)node;
                seq.getValue().addAll(seq2.getValue());
                return;
            }
            case mapping: {
                MappingNode map = (MappingNode)root;
                MappingNode map2 = (MappingNode)node;
                Iterator it = map2.getValue().iterator();
                while (it.hasNext()) {
                    NodeTuple t2 = (NodeTuple)it.next();
                    for (NodeTuple tuple : map.getValue()) {
                        Node key = tuple.getKeyNode();
                        Node key2 = t2.getKeyNode();
                        if (key.getNodeId() == NodeId.scalar) {
                            if (!((ScalarNode)key).getValue().equals(((ScalarNode)key2).getValue())) continue;
                            YamlUtils.merge(tuple.getValueNode(), t2.getValueNode(), source);
                            it.remove();
                            continue;
                        }
                        throw new ConfiguratorException(String.format("Found unmergeable configuration keys %s %s)", source, node.getEndMark()));
                    }
                }
                map.getValue().addAll(map2.getValue());
                return;
            }
        }
        throw new ConfiguratorException(String.format("Found conflicting configuration at %s %s", source.toString(), node.getStartMark()));
    }

    public static Mapping loadFrom(List<YamlSource> sources) throws ConfiguratorException {
        if (sources.isEmpty()) {
            return Mapping.EMPTY;
        }
        Node merged = YamlUtils.merge(sources);
        if (merged == null) {
            LOGGER.warning("configuration-as-code yaml source returned an empty document.");
            return Mapping.EMPTY;
        }
        return YamlUtils.loadFrom(merged);
    }

    private static Mapping loadFrom(final Node node) {
        ModelConstructor constructor = new ModelConstructor();
        constructor.setComposer(new Composer(null, null){

            public Node getSingleNode() {
                return node;
            }
        });
        return (Mapping)constructor.getSingleData(Mapping.class);
    }
}

