/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.plugins;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.Extension;
import hudson.Plugin;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.ProxyConfiguration;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.model.DownloadService;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.impl.attributes.MultivaluedAttribute;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Sequence;
import io.jenkins.plugins.casc.plugins.PluginToInstall;
import io.jenkins.plugins.casc.plugins.Plugins;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(ordinal=999.0)
@Restricted(value={NoExternalUse.class})
public class PluginManagerConfigurator
extends BaseConfigurator<PluginManager>
implements RootElementConfigurator<PluginManager> {
    private static final Logger logger = Logger.getLogger(PluginManagerConfigurator.class.getName());
    Cache<String, JSONObject> pluginVersions = CacheBuilder.newBuilder().build();

    @Override
    public Class<PluginManager> getTarget() {
        return PluginManager.class;
    }

    @Override
    public PluginManager getTargetComponent(ConfigurationContext context) {
        return Jenkins.getInstance().getPluginManager();
    }

    @Override
    protected PluginManager instance(Mapping mapping, ConfigurationContext context) {
        return this.getTargetComponent(context);
    }

    @Override
    protected void configure(Mapping config, PluginManager instance, boolean dryrun, ConfigurationContext context) throws ConfiguratorException {
        Mapping map = config.asMapping();
        Jenkins jenkins = Jenkins.getInstance();
        this.configureProxy(map, jenkins, context);
        UpdateCenter updateCenter = this.configureUpdateSites(map, jenkins, context);
        this.configurePlugins(map, jenkins, updateCenter, context);
        try {
            jenkins.save();
        }
        catch (IOException e) {
            throw new ConfiguratorException("failed to save Jenkins configuration", e);
        }
    }

    private void configureProxy(Mapping map, Jenkins jenkins, ConfigurationContext context) throws ConfiguratorException {
        CNode proxy = (CNode)map.get("proxy");
        if (proxy != null) {
            ProxyConfiguration pcc;
            Configurator pc = context.lookup((Type)((Object)ProxyConfiguration.class));
            if (pc == null) {
                throw new ConfiguratorException("ProxyConfiguration not well registered");
            }
            jenkins.proxy = pcc = (ProxyConfiguration)pc.configure(proxy, context);
        }
    }

    private UpdateCenter configureUpdateSites(Mapping map, Jenkins jenkins, ConfigurationContext context) throws ConfiguratorException {
        CNode sites = (CNode)map.get("sites");
        UpdateCenter updateCenter = jenkins.getUpdateCenter();
        if (sites != null) {
            Configurator usc = context.lookup((Type)((Object)UpdateSite.class));
            ArrayList<UpdateSite> updateSites = new ArrayList<UpdateSite>();
            for (CNode data : sites.asSequence()) {
                UpdateSite in = (UpdateSite)usc.configure(data, context);
                if (in.isDue()) {
                    in.updateDirectly(DownloadService.signatureCheck);
                }
                updateSites.add(in);
            }
            try {
                updateCenter.getSites().replaceBy(updateSites);
            }
            catch (IOException e) {
                throw new ConfiguratorException("failed to reconfigure updateCenter.sites", e);
            }
        }
        return updateCenter;
    }

    private PluginManager configurePlugins(Mapping map, Jenkins jenkins, UpdateCenter updateCenter, ConfigurationContext context) throws ConfiguratorException {
        LinkedList<PluginToInstall> plugins = new LinkedList<PluginToInstall>();
        CNode required = (CNode)map.get("required");
        if (required != null) {
            for (Map.Entry entry : required.asMapping().entrySet()) {
                plugins.add(new PluginToInstall((String)entry.getKey(), ((CNode)entry.getValue()).asScalar().getValue()));
            }
        }
        File shrinkwrap = this.readShrinkwrapFile(jenkins, plugins);
        PluginManager pluginManager = this.getTargetComponent(context);
        if (!plugins.isEmpty()) {
            logger.log(Level.CONFIG, String.format("Using plugin root dir: '%s'", pluginManager.rootDir));
            boolean requireRestart = false;
            HashSet<String> installed = new HashSet<String>();
            while (!plugins.isEmpty()) {
                PluginToInstall p = (PluginToInstall)plugins.remove();
                logger.fine("Preparing to install " + p.shortname);
                if (installed.contains(p.shortname)) {
                    logger.fine("Plugin " + p.shortname + " is already installed. Skipping");
                    continue;
                }
                Plugin plugin = jenkins.getPlugin(p.shortname);
                if (plugin != null && (!Character.isDigit(p.version.charAt(0)) && !"latest".equals(p.version) || plugin.getWrapper().getVersion().equals(p.version))) continue;
                UpdateSite.Plugin installable = this.getPluginMetadata(updateCenter, p);
                if ("latest".equals(p.version) && plugin != null && plugin.getWrapper().getVersion().equals(installable.version)) continue;
                requireRestart |= plugin != null;
                boolean downloaded = false;
                try {
                    logger.fine("Installing plugin: " + p.shortname);
                    UpdateCenter.UpdateCenterJob job = (UpdateCenter.UpdateCenterJob)installable.deploy(false).get();
                    if (job.getError() != null) {
                        if (job.getError() instanceof UpdateCenter.DownloadJob.SuccessButRequiresRestart) {
                            requireRestart = true;
                        } else {
                            throw job.getError();
                        }
                    }
                    installed.add(p.shortname);
                    File jpi = new File(pluginManager.rootDir, p.shortname + ".jpi");
                    try (JarFile jar = new JarFile(jpi);){
                        String dependencySpec = jar.getManifest().getMainAttributes().getValue("Plugin-Dependencies");
                        if (dependencySpec != null) {
                            List<PluginToInstall> pti = Arrays.stream(dependencySpec.split(",")).filter(t -> !t.endsWith(";resolution:=optional")).map(t -> t.substring(0, t.indexOf(58))).map(a -> new PluginToInstall((String)a, "latest")).collect(Collectors.toList());
                            pti.forEach(s -> logger.finest("Installing dependant plugin: " + s));
                            logger.finest("Adding " + pti.size() + " plugin(s) to install queue.");
                            plugins.addAll(pti);
                        }
                    }
                    downloaded = true;
                    continue;
                }
                catch (InterruptedException | ExecutionException ex) {
                    logger.info("Failed to download plugin " + p.shortname + ':' + p.version + " from " + p.site);
                }
                catch (Throwable ex) {
                    throw new ConfiguratorException("Failed to download plugin " + p.shortname + ':' + p.version, ex);
                }
                if (!downloaded) {
                    throw new ConfiguratorException("Failed to install plugin " + p.shortname + ':' + p.version);
                }
                logger.fine("Done installing plugins");
            }
            this.writeShrinkwrapFile(jenkins, shrinkwrap, pluginManager);
            if (requireRestart) {
                try {
                    jenkins.restart();
                }
                catch (RestartNotSupportedException e) {
                    throw new ConfiguratorException("Can't restart master after plugins installation", e);
                }
            }
        }
        return pluginManager;
    }

    private UpdateSite.Plugin getPluginMetadata(UpdateCenter updateCenter, PluginToInstall p) throws ConfiguratorException {
        if (!"latest".equals(p.version) && !Character.isDigit(p.version.charAt(0))) {
            String url = p.version;
            UpdateSite updateSite = (UpdateSite)updateCenter.getSites().get(0);
            if (updateSite == null) {
                throw new ConfiguratorException("Can't install " + p + ": no update site declared");
            }
            JSONObject json = new JSONObject();
            json.accumulate("name", (Object)p.shortname);
            json.accumulate("version", (Object)p.version);
            json.accumulate("url", (Object)url);
            json.accumulate("dependencies", (Object)new JSONArray());
            UpdateSite updateSite2 = updateSite;
            updateSite2.getClass();
            return new UpdateSite.Plugin(updateSite2, updateSite.getId(), json);
        }
        UpdateSite updateSite = updateCenter.getSite(p.site);
        if (updateSite == null) {
            throw new ConfiguratorException("Can't install " + p + ": unknown update site " + p.site);
        }
        if ("latest".equals(p.version)) {
            UpdateSite.Plugin plugin = updateSite.getPlugin(p.shortname);
            if (plugin == null) {
                throw new ConfiguratorException("update site " + p.site + " isn't hosting plugin " + p.shortname);
            }
            return plugin;
        }
        JSONObject versions = this.getPluginVersions(updateSite);
        if (versions == null) {
            throw new ConfiguratorException("update site " + p.site + " doesn't host plugin-versions.json metadata. Use plain download URL as 'version'");
        }
        JSONObject plugin = versions.getJSONObject(p.shortname);
        if (plugin == null) {
            throw new ConfiguratorException("update site " + p.site + " isn't hosting plugin " + p.shortname);
        }
        JSONObject version = plugin.getJSONObject(p.version);
        if (version == null) {
            throw new ConfiguratorException("update site " + p.site + " isn't hosting plugin " + p.shortname + " version " + p.version);
        }
        UpdateSite updateSite3 = updateSite;
        updateSite3.getClass();
        return new UpdateSite.Plugin(updateSite3, updateSite.getId(), version);
    }

    private JSONObject getPluginVersions(UpdateSite updateSite) {
        try {
            return (JSONObject)this.pluginVersions.get((Object)updateSite.getId(), () -> {
                boolean needUpdate;
                File file = new File(Jenkins.getInstance().getRootDir(), "updates/" + updateSite.getId() + "plugin-versions.json");
                boolean bl = needUpdate = !file.exists() || System.currentTimeMillis() - file.lastModified() > TimeUnit.DAYS.toMillis(1L);
                if (needUpdate) {
                    URI metadata = new URI(updateSite.getUrl()).resolve("./plugin-versions.json");
                    try (InputStream is = ProxyConfiguration.open((URL)metadata.toURL()).getInputStream();){
                        FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to download plugin-versions metadata from " + updateSite.getUrl(), e);
                    }
                }
                try {
                    return JSONObject.fromObject((Object)FileUtils.readFileToString((File)file)).getJSONObject("plugins");
                }
                catch (IOException e) {
                    return null;
                }
            });
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private File readShrinkwrapFile(Jenkins jenkins, Queue<PluginToInstall> plugins) throws ConfiguratorException {
        File shrinkwrap = new File(jenkins.getRootDir(), "plugins.txt");
        logger.log(Level.CONFIG, String.format("Using shrinkwrap file: '%s'", shrinkwrap.getAbsoluteFile()));
        HashMap<String, PluginToInstall> shrinkwrapped = new HashMap<String, PluginToInstall>();
        if (shrinkwrap.exists()) {
            try {
                List lines = FileUtils.readLines((File)shrinkwrap, (Charset)StandardCharsets.UTF_8);
                for (String line : lines) {
                    int i = line.indexOf(58);
                    String shortname = line.substring(0, i);
                    shrinkwrapped.put(shortname, new PluginToInstall(shortname, line.substring(i + 1)));
                }
            }
            catch (IOException e) {
                throw new ConfiguratorException("failed to load plugins.txt shrinkwrap file", e);
            }
            boolean outdated = false;
            for (PluginToInstall plugin : plugins) {
                PluginToInstall other = (PluginToInstall)shrinkwrapped.get(plugin.shortname);
                if (other != null && other.equals(plugin)) continue;
                outdated = true;
                break;
            }
            if (!outdated) {
                plugins.addAll(shrinkwrapped.values());
            }
        }
        return shrinkwrap;
    }

    private void writeShrinkwrapFile(Jenkins jenkins, File shrinkwrap, PluginManager pluginManager) throws ConfiguratorException {
        logger.fine("Writing shrinkwrap file: " + shrinkwrap);
        try (PrintWriter w = new PrintWriter(shrinkwrap, StandardCharsets.UTF_8.name());){
            for (PluginWrapper pw : pluginManager.getPlugins()) {
                if (pw.getShortName().equals("configuration-as-code")) continue;
                String from = "default";
                for (UpdateSite site : jenkins.getUpdateCenter().getSites()) {
                    if (site.getPlugin(pw.getShortName()) == null) continue;
                    from = site.getId();
                    break;
                }
                w.println(pw.getShortName() + ':' + pw.getVersionNumber().toString() + '@' + from);
            }
        }
        catch (IOException e) {
            throw new ConfiguratorException("failed to write plugins.txt shrinkwrap file", e);
        }
    }

    @Override
    public String getName() {
        return "plugins";
    }

    @Override
    public Set<Attribute<PluginManager, ?>> describe() {
        HashSet attr = new HashSet();
        attr.add(new Attribute("proxy", ProxyConfiguration.class));
        attr.add(new MultivaluedAttribute("sites", UpdateSite.class));
        attr.add(new MultivaluedAttribute("required", Plugins.class));
        return attr;
    }

    @Override
    @CheckForNull
    public CNode describe(PluginManager instance, ConfigurationContext context) throws Exception {
        Mapping mapping = new Mapping();
        Configurator cp = context.lookupOrFail((Type)((Object)ProxyConfiguration.class));
        ProxyConfiguration proxy = Jenkins.getInstance().proxy;
        if (proxy != null) {
            mapping.putIfNotNull("proxy", cp.describe(proxy, context));
        }
        Sequence seq = new Sequence();
        Configurator cs = context.lookupOrFail((Type)((Object)UpdateSite.class));
        for (UpdateSite site : Jenkins.getInstance().getUpdateCenter().getSiteList()) {
            seq.add(cs.describe(site, context));
        }
        mapping.putIfNotEmpry("sites", seq);
        return mapping;
    }
}

