/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.secrets;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import io.jenkins.plugins.casc.SecretSource;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

@Extension
public class DockerSecretSource
extends SecretSource {
    public static final String DOCKER_SECRETS = "/run/secrets/";
    private final File secrets;

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public DockerSecretSource() {
        String s = System.getenv("SECRETS");
        this.secrets = s != null ? new File(s) : new File(DOCKER_SECRETS);
    }

    @Override
    public Optional<String> reveal(String secret) throws IOException {
        File file = new File(this.secrets, secret);
        if (file.exists()) {
            return Optional.of(FileUtils.readFileToString((File)file).trim());
        }
        return Optional.empty();
    }
}

