/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import hudson.util.Secret;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.SecretSource;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Scalar;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

@Restricted(value={NoExternalUse.class})
public class PrimitiveConfigurator
implements Configurator {
    private final Class target;

    public PrimitiveConfigurator(Class clazz) {
        this.target = clazz;
    }

    public Class getTarget() {
        return this.target;
    }

    public Set<Attribute> describe() {
        return Collections.EMPTY_SET;
    }

    public Object configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
        String value;
        String s = value = config.asScalar().getValue();
        Optional<String> r = SecretSource.requiresReveal(value);
        if (r.isPresent()) {
            Optional<String> defaultValue;
            String expr = r.get();
            Optional<Object> reveal = Optional.empty();
            for (SecretSource secretSource : context.getSecretSources()) {
                try {
                    reveal = secretSource.reveal(expr);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Cannot reveal secret source for variable with key: " + s, ex);
                }
                if (!reveal.isPresent()) continue;
                s = (String)reveal.get();
                break;
            }
            if ((defaultValue = SecretSource.defaultValue(value)).isPresent() && !reveal.isPresent()) {
                s = defaultValue.get();
            }
            if (!reveal.isPresent() && !defaultValue.isPresent()) {
                throw new RuntimeException("Unable to reveal variable with key: " + s);
            }
        }
        return Stapler.lookupConverter((Class)this.target).convert(this.target, (Object)s);
    }

    public Object check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return this.configure(config, context);
    }

    @CheckForNull
    public CNode describe(Object instance, ConfigurationContext context) {
        if (instance == null) {
            return null;
        }
        if (instance instanceof Number) {
            return new Scalar((Number)instance);
        }
        if (instance instanceof Boolean) {
            return new Scalar((Boolean)instance);
        }
        if (instance instanceof Secret) {
            return new Scalar(((Secret)instance).getEncryptedValue());
        }
        if (this.target.isEnum()) {
            return new Scalar((Enum)instance);
        }
        return new Scalar(String.valueOf(instance));
    }

    @Override
    public List<Configurator> getConfigurators(ConfigurationContext context) {
        return Collections.emptyList();
    }
}

