/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.ObsoleteConfigurationMonitor;
import io.jenkins.plugins.casc.impl.attributes.DescribableAttribute;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Scalar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class HeteroDescribableConfigurator<T extends Describable>
implements Configurator<T> {
    private static final Logger LOGGER = Logger.getLogger(HeteroDescribableConfigurator.class.getName());
    private final Class<T> target;

    public HeteroDescribableConfigurator(Class<T> clazz) {
        this.target = clazz;
    }

    @Override
    public Class<T> getTarget() {
        return this.target;
    }

    @Override
    public List<Configurator> getConfigurators(ConfigurationContext context) {
        DescriptorExtensionList candidates = Jenkins.getInstance().getDescriptorList(this.target);
        List<Configurator> configurators = candidates.stream().map(d -> context.lookup(d.getKlass().toJavaClass())).filter(c -> c != null).collect(Collectors.toList());
        configurators.add(this);
        return configurators;
    }

    @Override
    public T configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
        String shortname;
        CNode subconfig = null;
        switch (config.getType()) {
            case SCALAR: {
                shortname = config.asScalar().getValue();
                break;
            }
            case MAPPING: {
                Mapping map = config.asMapping();
                if (map.size() != 1) {
                    throw new IllegalArgumentException("single entry map expected to configure a " + this.target.getName());
                }
                Map.Entry next = map.entrySet().iterator().next();
                shortname = (String)next.getKey();
                subconfig = (CNode)next.getValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected configuration type " + config);
            }
        }
        DescriptorExtensionList candidates = Jenkins.getInstance().getDescriptorList(this.target);
        Class<T> k = this.findDescribableBySymbol(config, shortname, (List<Descriptor>)candidates);
        Configurator configurator = context.lookup(k);
        if (configurator == null) {
            throw new IllegalStateException("No configurator implementation to manage " + k);
        }
        return (T)((Describable)configurator.configure(subconfig, context));
    }

    @Override
    public T check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return this.configure(config, context);
    }

    public Map<String, Class> getImplementors() {
        Class api = this.getImplementedAPI();
        DescriptorExtensionList descriptors = Jenkins.getInstance().getDescriptorList(this.target);
        return descriptors.stream().collect(Collectors.toMap(d -> DescribableAttribute.getSymbols(d, api, this.target).get(0), d -> d.getKlass().toJavaClass()));
    }

    private boolean _hasSupportPluginInstalled() {
        return Jenkins.getInstance().getPlugin("configuration-as-code-support") != null;
    }

    private Class<T> findDescribableBySymbol(CNode node, String shortname, List<Descriptor> candidates) {
        Class api = this.getImplementedAPI();
        for (Descriptor d : candidates) {
            List<String> symbols = DescribableAttribute.getSymbols(d, api, this.target);
            String preferred = symbols.get(0);
            if (preferred.equalsIgnoreCase(shortname)) {
                return d.getKlass().toJavaClass();
            }
            for (String symbol : symbols) {
                if (!symbol.equalsIgnoreCase(shortname)) continue;
                ObsoleteConfigurationMonitor.get().record(node, "'" + shortname + "' is obsolete, please use '" + preferred + "'");
                return d.getKlass().toJavaClass();
            }
        }
        String errSupport = !this._hasSupportPluginInstalled() ? "\nPossible solution: Try to install 'configuration-as-code-support' plugin" : "";
        String msg = "No " + this.target.getName() + " implementation found for " + shortname;
        throw new IllegalArgumentException(String.format("%s%s", msg, errSupport));
    }

    @Override
    public Set<Attribute<T, ?>> describe() {
        return Collections.emptySet();
    }

    @Override
    @CheckForNull
    public CNode describe(Describable instance, ConfigurationContext context) throws Exception {
        String symbol = DescribableAttribute.getPreferredSymbol(instance.getDescriptor(), this.getTarget(), instance.getClass());
        Configurator c = context.lookupOrFail(instance.getClass());
        CNode describe = c.describe(instance, context);
        if (describe == null) {
            return null;
        }
        if (describe.getType() == CNode.Type.MAPPING && describe.asMapping().size() == 0) {
            return new Scalar(symbol);
        }
        Mapping mapping = new Mapping();
        mapping.put(symbol, describe);
        return mapping;
    }
}

