/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import hudson.model.Descriptor;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.impl.configurators.DescriptorConfigurator;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Scalar;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class GlobalConfigurationCategoryConfigurator
extends BaseConfigurator<GlobalConfigurationCategory>
implements RootElementConfigurator<GlobalConfigurationCategory> {
    private static final Logger logger = Logger.getLogger(GlobalConfigurationCategoryConfigurator.class.getName());
    private final GlobalConfigurationCategory category;

    public GlobalConfigurationCategoryConfigurator(GlobalConfigurationCategory category) {
        this.category = category;
    }

    @Override
    public String getName() {
        Class<?> c = this.category.getClass();
        Symbol symbol = c.getAnnotation(Symbol.class);
        if (symbol != null) {
            return symbol.value()[0];
        }
        String name = c.getSimpleName();
        name = StringUtils.remove((String)name, (String)"Global");
        name = StringUtils.remove((String)name, (String)"Configuration");
        name = StringUtils.remove((String)name, (String)"Category");
        return name.toLowerCase();
    }

    @Override
    public Class getTarget() {
        return this.category.getClass();
    }

    @Override
    public GlobalConfigurationCategory getTargetComponent(ConfigurationContext context) {
        return this.category;
    }

    @Override
    protected GlobalConfigurationCategory instance(Mapping mapping, ConfigurationContext context) {
        return this.category;
    }

    @Override
    public Set describe() {
        return Jenkins.getInstance().getExtensionList(Descriptor.class).stream().filter(d -> d.getCategory() == this.category).filter(d -> d.getGlobalConfigPage() != null).map(d -> new DescriptorConfigurator((Descriptor)d)).map(c -> new Attribute(c.getName(), c.getTarget()).setter(Attribute.Setter.NOP)).collect(Collectors.toSet());
    }

    @Override
    @CheckForNull
    public CNode describe(GlobalConfigurationCategory instance, ConfigurationContext context) {
        Mapping mapping = new Mapping();
        Jenkins.getInstance().getExtensionList(Descriptor.class).stream().filter(d -> d.getCategory() == this.category).filter(d -> d.getGlobalConfigPage() != null).forEach(d -> this.describe((Descriptor)d, mapping, context));
        return mapping;
    }

    private void describe(Descriptor d, Mapping mapping, ConfigurationContext context) {
        DescriptorConfigurator c = new DescriptorConfigurator(d);
        try {
            CNode node = c.describe(d, context);
            if (node != null) {
                mapping.put(c.getName(), node);
            }
        }
        catch (Exception e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            Scalar scalar = new Scalar("FAILED TO EXPORT " + d.getClass().getName() + " : \n" + w.toString());
            mapping.put(c.getName(), scalar);
        }
    }
}

