/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.Configurable;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.CNode;
import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ConfigurableConfigurator<T extends Configurable>
implements Configurator<T> {
    private final Class<T> target;

    public ConfigurableConfigurator(Class<T> target) {
        this.target = target;
    }

    @Override
    public Class<T> getTarget() {
        return this.target;
    }

    @Override
    @Nonnull
    public Set<Attribute<T, ?>> describe() {
        return Collections.emptySet();
    }

    @Override
    @Nonnull
    public T configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
        try {
            Configurable instance = (Configurable)this.target.newInstance();
            instance.configure(config);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfiguratorException("Cannot instantiate Configurable " + this.target + " with default constructor", e);
        }
    }

    @Override
    public T check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        try {
            Configurable instance = (Configurable)this.target.newInstance();
            instance.check(config);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfiguratorException("Cannot instantiate Configurable " + this.target + " with default constructor", e);
        }
    }

    @Override
    @CheckForNull
    public CNode describe(T instance, ConfigurationContext context) throws Exception {
        return instance.describe();
    }
}

