/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.core;

import hudson.Extension;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.security.s2m.AdminWhitelistRule;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class JenkinsConfigurator
extends BaseConfigurator<Jenkins>
implements RootElementConfigurator<Jenkins> {
    private static final Logger LOGGER = Logger.getLogger(JenkinsConfigurator.class.getName());

    @Override
    public Class<Jenkins> getTarget() {
        return Jenkins.class;
    }

    @Override
    public Jenkins getTargetComponent(ConfigurationContext context) {
        return Jenkins.getInstance();
    }

    @Override
    protected Jenkins instance(Mapping mapping, ConfigurationContext context) {
        return this.getTargetComponent(context);
    }

    @Override
    public Set<Attribute<Jenkins, ?>> describe() {
        Set<Attribute<Jenkins, ?>> attributes = super.describe();
        attributes.add(new Attribute<Jenkins, AdminWhitelistRule>("remotingSecurity", AdminWhitelistRule.class).getter(j -> (AdminWhitelistRule)j.getInjector().getInstance(AdminWhitelistRule.class)).setter(Attribute.noop()));
        Attribute.get(attributes, "nodes").ifPresent(a -> a.getter(j -> j.getNodes().stream().filter(node -> node.getDescriptor().isInstantiable()).collect(Collectors.toList())));
        return attributes;
    }

    @Override
    protected Set<String> exclusions() {
        return Collections.singleton("installState");
    }

    @Override
    @CheckForNull
    public CNode describe(Jenkins instance, ConfigurationContext context) throws Exception {
        Mapping mapping = new Mapping();
        for (Attribute attribute : this.getAttributes()) {
            mapping.put(attribute.getName(), attribute.describe(instance, context));
        }
        return mapping;
    }

    @Override
    public String getName() {
        return "jenkins";
    }
}

