/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.model.Source;
import io.jenkins.plugins.casc.yaml.YamlSource;
import java.io.InputStream;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class CheckConfigurationCommand
extends CLICommand {
    public String getShortDescription() {
        return "Apply YAML configuration to instance";
    }

    protected int run() throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            return -1;
        }
        Map<Source, String> issues = ConfigurationAsCode.get().checkWith(new YamlSource<InputStream>(this.stdin, YamlSource.READ_FROM_INPUTSTREAM));
        for (Map.Entry<Source, String> entry : issues.entrySet()) {
            this.stderr.printf("warning: line %d %s", entry.getKey().line, entry.getValue());
        }
        return 0;
    }
}

