/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import io.jenkins.plugins.casc.Configurator;
import java.io.IOException;
import javax.annotation.CheckForNull;

public class ConfiguratorException
extends IOException {
    @CheckForNull
    private final Configurator configurator;

    public ConfiguratorException(@CheckForNull Configurator configurator, @CheckForNull String message, @CheckForNull Throwable cause) {
        super(message, cause);
        this.configurator = configurator;
    }

    public ConfiguratorException(@CheckForNull String message, @CheckForNull Throwable cause) {
        this(null, message, cause);
    }

    public ConfiguratorException(@CheckForNull Configurator configurator, @CheckForNull String message) {
        this(configurator, message, null);
    }

    public ConfiguratorException(@CheckForNull String message) {
        this(null, message, null);
    }

    public ConfiguratorException(@CheckForNull Throwable cause) {
        this(null, null, cause);
    }

    @CheckForNull
    public Configurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public String getMessage() {
        if (this.configurator != null) {
            return String.format("%s: %s", this.configurator.getName(), super.getMessage());
        }
        return super.getMessage();
    }
}

