/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.CNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;

public interface Configurator<T> {
    @Nonnull
    public static String normalize(@Nonnull String name) {
        name = name.toUpperCase().equals(name) ? name.toLowerCase() : StringUtils.uncapitalize((String)name);
        return name;
    }

    @Nonnull
    default public String getName() {
        Symbol annotation = this.getTarget().getAnnotation(Symbol.class);
        if (annotation != null) {
            return annotation.value()[0];
        }
        return Configurator.normalize(this.getTarget().getSimpleName());
    }

    default public String getDisplayName() {
        return this.getName();
    }

    public Class<T> getTarget();

    default public boolean canConfigure(Class clazz) {
        return clazz == this.getTarget();
    }

    @Nonnull
    default public Class getImplementedAPI() {
        return this.getTarget();
    }

    @Nonnull
    default public List<Configurator> getConfigurators(ConfigurationContext context) {
        return Collections.singletonList(this);
    }

    @Nonnull
    public Set<Attribute<T, ?>> describe();

    @Nonnull
    default public List<Attribute<T, ?>> getAttributes() {
        return this.describe().stream().filter(a -> !a.isRestricted()).filter(a -> !a.isDeprecated()).sorted(Comparator.comparing(a -> a.name)).collect(Collectors.toList());
    }

    @Nonnull
    public T configure(CNode var1, ConfigurationContext var2) throws ConfiguratorException;

    public T check(CNode var1, ConfigurationContext var2) throws ConfiguratorException;

    @CheckForNull
    public CNode describe(T var1, ConfigurationContext var2) throws Exception;
}

