/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.yaml;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.AbstractMapDecorator;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.jenkinsci.plugins.casc.model.Scalar;
import org.jenkinsci.plugins.casc.model.Sequence;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class ModelConstructor
extends Constructor {
    private static final Construct ConstructScalar = new AbstractConstruct(){

        public Object construct(Node node) {
            return new Scalar(((ScalarNode)node).getValue());
        }
    };

    public ModelConstructor() {
        super(Mapping.class);
        this.yamlConstructors.put(Tag.BOOL, ConstructScalar);
        this.yamlConstructors.put(Tag.INT, ConstructScalar);
    }

    protected Object constructScalar(ScalarNode node) {
        return new Scalar(node.getValue());
    }

    protected Map createDefaultMap() {
        return new Mapping();
    }

    protected void constructMapping2ndStep(MappingNode node, final Map<Object, Object> mapping) {
        super.constructMapping2ndStep(node, (Map)new AbstractMapDecorator(mapping){

            public Object put(Object key, Object value) {
                if (!(key instanceof Scalar)) {
                    throw new IllegalStateException("We only support scalar map keys");
                }
                if (value instanceof Number) {
                    value = new Scalar(value.toString());
                } else if (value instanceof Boolean) {
                    value = new Scalar(value.toString());
                }
                return mapping.put(key.toString(), value);
            }
        });
    }

    protected List createDefaultList(int initSize) {
        return new Sequence(initSize);
    }
}

