/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.commons.stapler.TreeResponse;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueArtifactContainer;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueItemRun;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Resource;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.verb.POST;
import org.kohsuke.stapler.verb.PUT;

@Capability(value={"io.jenkins.blueocean.rest.model.BlueRun"})
public abstract class BlueRun
extends Resource
implements BlueItemRun {
    public static final String ORGANIZATION = "organization";
    public static final String ID = "id";
    public static final String PIPELINE = "pipeline";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String ENQUEUE_TIME = "enQueueTime";
    public static final String DURATION_IN_MILLIS = "durationInMillis";
    public static final String ESTIMATED_DURATION_IN_MILLIS = "estimatedDurationInMillis";
    public static final String TYPE = "type";
    public static final String RUN_SUMMARY = "runSummary";
    public static final String RESULT = "result";
    public static final String STATE = "state";
    public static final String CAUSE_OF_BLOCKAGE = "causeOfBlockage";
    public static final String REPLAYABLE = "replayable";
    public static final String TEST_SUMMARY = "testSummary";
    public static final String ACTIONS = "actions";
    public static final String CAUSES = "causes";
    public static final int DEFAULT_BLOCKING_STOP_TIMEOUT_IN_SECS = 10;
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    @Override
    @Exported(name="organization")
    public abstract String getOrganization();

    @Override
    @Exported(name="id")
    public abstract String getId();

    @Override
    @Exported(name="pipeline")
    public abstract String getPipeline();

    @Override
    @Exported(name="name")
    public abstract String getName();

    @Override
    @Exported(name="description")
    public abstract String getDescription();

    public abstract Date getStartTime();

    @Override
    @Exported(inline=true)
    @Nonnull
    public abstract Container<BlueChangeSetEntry> getChangeSet();

    @Override
    @Exported(name="startTime")
    public abstract String getStartTimeString();

    public abstract Date getEnQueueTime();

    @Override
    @Exported(name="enQueueTime")
    public abstract String getEnQueueTimeString();

    public abstract Date getEndTime();

    @Override
    @Exported(name="endTime")
    public abstract String getEndTimeString();

    @Override
    @Exported(name="durationInMillis")
    public abstract Long getDurationInMillis();

    @Override
    @Exported(name="estimatedDurationInMillis")
    public abstract Long getEstimatedDurtionInMillis();

    @Override
    @Exported(name="state")
    public abstract BlueRunState getStateObj();

    @Override
    @Exported(name="result")
    public abstract BlueRunResult getResult();

    @Override
    @Exported(name="runSummary")
    public abstract String getRunSummary();

    @Override
    @Exported(name="type")
    public abstract String getType();

    @PUT
    @TreeResponse
    @WebMethod(name={"stop"})
    public abstract BlueRun stop(@QueryParameter(value="blocking") Boolean var1, @QueryParameter(value="timeOutInSecs") Integer var2);

    @Override
    @Exported
    public abstract String getArtifactsZipFile();

    @Override
    @Navigable
    public abstract BlueArtifactContainer getArtifacts();

    public abstract BluePipelineNodeContainer getNodes();

    @Override
    @Navigable
    @Exported(name="actions", inline=true)
    public abstract Collection<BlueActionProxy> getActions();

    public abstract BluePipelineStepContainer getSteps();

    @Override
    @Navigable
    public abstract BlueTestResultContainer getTests();

    @Override
    @Deprecated
    public abstract BlueTestSummary getTestSummary();

    @Navigable
    public abstract BlueTestSummary getBlueTestSummary();

    @Override
    @Navigable
    public abstract Object getLog();

    @POST
    @TreeResponse
    @WebMethod(name={"replay"})
    public abstract BlueRun replay();

    @Override
    @Exported(name="causes", inline=true)
    public abstract Collection<BlueCause> getCauses();

    @Override
    @Exported(name="causeOfBlockage")
    public abstract String getCauseOfBlockage();

    @Override
    @Exported(name="replayable")
    public abstract boolean isReplayable();

    public static enum BlueRunResult {
        SUCCESS,
        UNSTABLE,
        FAILURE,
        NOT_BUILT,
        UNKNOWN,
        ABORTED;

    }

    public static enum BlueRunState {
        QUEUED,
        RUNNING,
        PAUSED,
        SKIPPED,
        NOT_BUILT,
        FINISHED;

    }

    @ExportedBean
    public static abstract class BlueCause {
        public abstract String getShortDescription();

        @Exported(name="cause", merge=true)
        public abstract Object getCause();
    }
}

