/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.jenkins.blueocean.commons.ServiceException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class Utils {
    public static <T> T cast(String value, Class<T> type) {
        try {
            if (String.class.isAssignableFrom(type)) {
                return (T)value;
            }
            if (Integer.class.isAssignableFrom(type)) {
                return (T)Integer.valueOf(value);
            }
            if (Long.class.isAssignableFrom(type)) {
                return (T)Long.valueOf(value);
            }
            if (Boolean.class.isAssignableFrom(type)) {
                return (T)Boolean.valueOf(value);
            }
            if (List.class.isAssignableFrom(type)) {
                String[] vs = value.split(",");
                ArrayList<String> list = new ArrayList<String>();
                for (String v : vs) {
                    list.add(v.trim());
                }
                return (T)ImmutableList.of(list);
            }
            if (Set.class.isAssignableFrom(type)) {
                String[] vs = value.split(",");
                HashSet<String> set = new HashSet<String>();
                for (String v : vs) {
                    set.add(v.trim());
                }
                return (T)ImmutableSet.of(set);
            }
            throw new ServiceException.UnexpectedErrorException(String.format("Unknown type %s", type));
        }
        catch (NumberFormatException e) {
            throw new ServiceException.BadRequestException(String.format("Value %s can't be converted to type: %s", value, type));
        }
    }

    public static String ensureTrailingSlash(@Nonnull String path) {
        return path.charAt(path.length() - 1) == '/' ? path : path + "/";
    }

    public static <T> int skip(Iterator<T> base, int offset) {
        int i;
        Preconditions.checkArgument((base != null ? 1 : 0) != 0);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        for (i = 0; i < offset && base.hasNext(); ++i) {
            base.next();
        }
        return i;
    }
}

