/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.pageable;

import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.commons.stapler.TreeResponse;
import io.jenkins.blueocean.rest.pageable.Pageable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Spliterators;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javax.servlet.ServletException;
import org.kohsuke.stapler.CancelRequestHandlingException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.Interceptor;
import org.kohsuke.stapler.interceptor.InterceptorAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@InterceptorAnnotation(value=Processor.class)
public @interface PagedResponse {
    public static final int DEFAULT_LIMIT = 100;

    public static class Processor
    extends Interceptor {
        public Object invoke(StaplerRequest request, StaplerResponse response, Object instance, Object[] arguments) throws IllegalAccessException, InvocationTargetException, ServletException {
            String method = request.getMethod();
            if (!method.equalsIgnoreCase("GET") && !this.postRouteMatches(request, TreeResponse.Processor.SCM_ORGANIZATIONS_URI)) {
                throw new CancelRequestHandlingException();
            }
            Pageable resp = (Pageable)this.target.invoke(request, response, instance, arguments);
            return (req, rsp, node) -> {
                String q;
                int limit;
                int start = req.getParameter("start") != null ? Integer.parseInt(req.getParameter("start")) : 0;
                int n = limit = req.getParameter("limit") != null ? Integer.parseInt(req.getParameter("limit")) : 100;
                if (start < 0) {
                    start = 0;
                }
                if (limit < 0) {
                    limit = 100;
                }
                Object[] page = StreamSupport.stream(Spliterators.spliteratorUnknownSize(resp.iterator(start, limit), 4), false).toArray();
                Object url = req.getOriginalRequestURI();
                String separator = "?";
                if (req.getQueryString() != null && (q = this.getQueryString(req.getQueryString(), "start", "limit")).length() > 0) {
                    url = (String)url + "?" + q;
                    separator = "&";
                }
                rsp.setHeader("Link", "<" + (String)url + separator + "start=" + (start + limit) + "&limit=" + limit + ">; rel=\"next\"");
                Export.doJson((StaplerRequest)req, (StaplerResponse)rsp, (Object)page);
            };
        }

        private String getQueryString(String query, String ... excludes) {
            List<String> excludeList = Arrays.asList(excludes);
            String[] values = query.split("&");
            StringBuilder sb = new StringBuilder();
            for (String v : values) {
                String[] vv = v.split("=");
                if (vv.length != 2 || excludeList.contains(vv[0].trim())) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(vv[0].trim()).append("=").append(vv[1].trim());
            }
            return sb.toString();
        }

        private boolean postRouteMatches(StaplerRequest request, Pattern pattern) {
            String method = request.getMethod();
            if (!"POST".equalsIgnoreCase(method)) {
                return false;
            }
            return pattern.matcher(request.getOriginalRequestURI()).find();
        }
    }
}

