/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.hal;

import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.Resource;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jvnet.tiger_types.Types;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.Exported;

public final class Links
extends HashMap<String, Link> {
    private final Resource self;
    private static final String SELF = "self";

    public Links(Resource self) {
        this.self = self;
        this.getOrCreateSelfRef();
        this.populateReferences();
    }

    public Links add(String ref, Link link) {
        this.put(ref, link);
        return this;
    }

    public Link self() {
        return (Link)this.get(SELF);
    }

    public Links add(String ref) {
        this.put(ref, new Link(((Link)this.get(SELF)).getHref() + ref));
        return this;
    }

    private void populateReferences() {
        Class<?> clazz = this.self.getClass();
        for (Method m : this.findMethods(clazz, clazz, new ArrayList<Method>())) {
            String p = this.getPathFromMethodName(m);
            this.put(p, this.createLinkRef(p));
        }
    }

    private List<Method> findMethods(Class c, Type logical, List<Method> r) {
        for (Class<?> i : c.getInterfaces()) {
            this.findMethods(i, Types.getBaseClass((Type)logical, i), r);
        }
        Class sc = c.getSuperclass();
        if (sc != null) {
            this.findMethods(sc, Types.getBaseClass((Type)logical, sc), r);
        }
        for (Method method : c.getDeclaredMethods()) {
            if (method.getAnnotation(Navigable.class) == null) continue;
            r.add(method);
        }
        return r;
    }

    private Link getOrCreateSelfRef() {
        Link ref = (Link)this.get(SELF);
        if (ref != null) {
            return ref;
        }
        ref = this.self.getLink();
        this.put(SELF, ref);
        return ref;
    }

    private Link createLinkRef(String name) {
        String base = this.self().getHref();
        base = Links.ensureTrailingSlash(base);
        return new Link(String.format("%s%s/", base, name));
    }

    private String getPathFromMethodName(Method m) {
        String methodName = m.getName();
        Exported exportedAnn = m.getAnnotation(Exported.class);
        if (exportedAnn != null && !exportedAnn.name().trim().isEmpty()) {
            return exportedAnn.name();
        }
        if (methodName.startsWith("get")) {
            return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        if (methodName.startsWith("do")) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return "";
    }

    private String getBasePath() {
        int i;
        String path = Stapler.getCurrentRequest().getPathInfo();
        String contextPath = Stapler.getCurrentRequest().getContextPath().trim();
        if (!(contextPath.isEmpty() && contextPath.equals("/") || (i = path.indexOf(contextPath)) < 0 || path.length() <= i)) {
            int j = path.indexOf(47, i + 1);
            return path.substring(j);
        }
        return path;
    }

    public static String ensureTrailingSlash(String path) {
        if (path.charAt(path.length() - 1) != '/') {
            return path + "/";
        }
        return path;
    }
}

