/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.commons.stapler.TreeResponse;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BlueManagedSource;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipelineItem;
import io.jenkins.blueocean.rest.model.BluePipelineScm;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.BlueRunnableItem;
import io.jenkins.blueocean.rest.model.BlueTrendContainer;
import io.jenkins.blueocean.rest.model.Resource;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.verb.PUT;

@Capability(value={"io.jenkins.blueocean.rest.model.BluePipeline"})
public abstract class BluePipeline
extends Resource
implements BluePipelineItem,
BlueRunnableItem,
BlueManagedSource {
    public static final String ORGANIZATION = "organization";
    public static final String NAME = "name";
    public static final String DISPLAY_NAME = "displayName";
    public static final String FULL_NAME = "fullName";
    public static final String FULL_DISPLAY_NAME = "fullDisplayName";
    public static final String WEATHER_SCORE = "weatherScore";
    public static final String LATEST_RUN = "latestRun";
    public static final String ESTIMATED_DURATION = "estimatedDurationInMillis";
    public static final String ACTIONS = "actions";
    public static final String PERMISSIONS = "permissions";
    public static final String DISABLED = "disabled";
    public static final String CREATE_PERMISSION = "create";
    public static final String READ_PERMISSION = "read";
    public static final String START_PERMISSION = "start";
    public static final String STOP_PERMISSION = "stop";
    public static final String CONFIGURE_PERMISSION = "configure";
    private static final String PARAMETERS = "parameters";

    @Override
    @Nonnull
    public abstract BlueOrganization getOrganization();

    @Override
    @Exported(name="organization")
    public abstract String getOrganizationName();

    @Override
    @Exported(name="name")
    public abstract String getName();

    @Override
    @Exported(name="displayName")
    public abstract String getDisplayName();

    @Override
    @Exported(name="fullName")
    public abstract String getFullName();

    @Override
    @Exported(name="fullDisplayName")
    public abstract String getFullDisplayName();

    @Override
    @Exported(name="weatherScore")
    public abstract Integer getWeatherScore();

    @Override
    @Exported(name="latestRun", inline=true)
    public abstract BlueRun getLatestRun();

    @Exported(name="disabled", inline=true)
    public abstract Boolean getDisabled();

    @Override
    @Exported(name="estimatedDurationInMillis")
    public abstract Long getEstimatedDurationInMillis();

    @Override
    @Navigable
    @CheckForNull
    public abstract BlueRunContainer getRuns();

    @Override
    @Navigable
    @Exported(name="actions", inline=true)
    public abstract Collection<BlueActionProxy> getActions();

    @Override
    @Navigable
    public abstract BlueQueueContainer getQueue();

    @Override
    @Exported(name="parameters", inline=true)
    public abstract List<Object> getParameters();

    @PUT
    @WebMethod(name={"favorite"})
    @TreeResponse
    public abstract BlueFavorite favorite(@JsonBody BlueFavoriteAction var1);

    @PUT
    @WebMethod(name={"enable"})
    public abstract void enable() throws IOException;

    @PUT
    @WebMethod(name={"disable"})
    public abstract void disable() throws IOException;

    @Exported(name="permissions")
    public abstract Map<String, Boolean> getPermissions();

    @Override
    public abstract BluePipelineScm getScm();

    @Override
    @Navigable
    public abstract BlueTrendContainer getTrends();
}

