/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueArtifactContainer;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import io.jenkins.blueocean.rest.model.Container;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.export.Exported;

@Capability(value={"io.jenkins.blueocean.rest.model.BlueRun"})
public interface BlueItemRun {
    @Exported(name="organization")
    public String getOrganization();

    @Exported(name="id")
    public String getId();

    @Exported(name="pipeline")
    public String getPipeline();

    @Exported(name="name")
    public String getName();

    @Exported(name="description")
    public String getDescription();

    @Exported(inline=true)
    @Nonnull
    @Navigable
    public Container<BlueChangeSetEntry> getChangeSet();

    @Exported(name="startTime")
    public String getStartTimeString();

    @Exported(name="enQueueTime")
    public String getEnQueueTimeString();

    @Exported(name="endTime")
    public String getEndTimeString();

    @Exported(name="durationInMillis")
    public Long getDurationInMillis();

    @Exported(name="estimatedDurationInMillis")
    public Long getEstimatedDurtionInMillis();

    @Exported(name="state")
    public BlueRun.BlueRunState getStateObj();

    @Exported(name="result")
    public BlueRun.BlueRunResult getResult();

    @Exported(name="runSummary")
    public String getRunSummary();

    @Exported(name="type")
    public String getType();

    @Exported
    public String getArtifactsZipFile();

    @Navigable
    public BlueArtifactContainer getArtifacts();

    @Navigable
    @Exported(name="actions", inline=true)
    public Collection<BlueActionProxy> getActions();

    @Navigable
    public BlueTestResultContainer getTests();

    @Exported(name="testSummary", inline=true, skipNull=true)
    public BlueTestSummary getTestSummary();

    @Navigable
    public Object getLog();

    @Exported(name="causes", inline=true)
    public Collection<BlueRun.BlueCause> getCauses();

    @Exported(name="causeOfBlockage")
    public String getCauseOfBlockage();

    @Exported(name="replayable")
    public boolean isReplayable();
}

