/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.factory;

import com.google.common.collect.Sets;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Job;
import hudson.scm.ChangeLogSet;
import io.jenkins.blueocean.rest.model.BlueIssue;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BlueIssueFactory
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(BlueIssueFactory.class.getName());

    public abstract Collection<BlueIssue> getIssues(Job var1);

    public abstract Collection<BlueIssue> getIssues(ChangeLogSet.Entry var1);

    public static Collection<BlueIssue> resolve(Job job) {
        LinkedHashSet allIssues = Sets.newLinkedHashSet();
        for (BlueIssueFactory factory : ExtensionList.lookup(BlueIssueFactory.class)) {
            try {
                Collection<BlueIssue> issues = factory.getIssues(job);
                if (issues == null) continue;
                allIssues.addAll(issues);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to fetch issues for job " + e.getMessage(), e);
            }
        }
        return allIssues;
    }

    public static Collection<BlueIssue> resolve(ChangeLogSet.Entry changeSetEntry) {
        LinkedHashSet allIssues = Sets.newLinkedHashSet();
        for (BlueIssueFactory factory : ExtensionList.lookup(BlueIssueFactory.class)) {
            try {
                Collection<BlueIssue> issues = factory.getIssues(changeSetEntry);
                if (issues == null) continue;
                allIssues.addAll(issues);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to fetch issues for changeSetEntry " + e.getMessage(), e);
            }
        }
        return allIssues;
    }
}

