/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.factory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionPoint;
import hudson.model.Run;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.model.BlueTestResult;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;

public abstract class BlueTestResultFactory
implements ExtensionPoint {
    public abstract Result getBlueTestResults(Run<?, ?> var1, Reachable var2);

    public static Result resolve(Run<?, ?> run, Reachable parent) {
        Object results = ImmutableList.of();
        BlueTestSummary summary = new BlueTestSummary(0L, 0L, 0L, 0L, 0L, 0L, 0L);
        for (BlueTestResultFactory factory : Jenkins.getInstance().getExtensionList(BlueTestResultFactory.class)) {
            Result result = factory.getBlueTestResults(run, parent);
            if (result == null || result.results == null || result.summary == null) continue;
            results = Iterables.concat(result.results, (Iterable)results);
            summary = summary.tally(result.summary);
        }
        if (summary.getTotal() == 0L) {
            summary = null;
            results = null;
        }
        return Result.of((Iterable<BlueTestResult>)results, summary);
    }

    public static final class Result {
        private static final Result NOT_FOUND = new Result((Iterable<BlueTestResult>)ImmutableList.of(), null);
        @Nullable
        public final Iterable<BlueTestResult> results;
        @Nullable
        public final BlueTestSummary summary;

        private Result(Iterable<BlueTestResult> results, BlueTestSummary summary) {
            this.results = results;
            this.summary = summary;
        }

        public static Result of(Iterable<BlueTestResult> results, BlueTestSummary summary) {
            return new Result(results, summary);
        }

        @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Its ok in this case")
        public static Result of(Iterable<BlueTestResult> results) {
            long skipped = 0L;
            long passed = 0L;
            long failed = 0L;
            long regressions = 0L;
            long existingFailedTotal = 0L;
            long fixedTotal = 0L;
            long total = 0L;
            for (BlueTestResult result : results) {
                block0 : switch (result.getStatus()) {
                    case SKIPPED: {
                        ++skipped;
                        break;
                    }
                    case PASSED: {
                        ++passed;
                        switch (result.getTestState()) {
                            case FIXED: {
                                ++fixedTotal;
                            }
                        }
                        break;
                    }
                    case FAILED: {
                        ++failed;
                        switch (result.getTestState()) {
                            case REGRESSION: {
                                ++regressions;
                                break block0;
                            }
                        }
                        ++existingFailedTotal;
                    }
                }
                ++total;
            }
            if (total == 0L) {
                return Result.notFound();
            }
            BlueTestSummary summary = new BlueTestSummary(passed, failed, fixedTotal, existingFailedTotal, regressions, skipped, total);
            return new Result(results, summary);
        }

        public static Result notFound() {
            return NOT_FOUND;
        }
    }
}

