/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.factory;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.Resource;
import jenkins.model.Jenkins;

public abstract class BluePipelineFactory
implements ExtensionPoint {
    public abstract BluePipeline getPipeline(Item var1, Reachable var2);

    public abstract Resource resolve(Item var1, Reachable var2, Item var3);

    public static ExtensionList<BluePipelineFactory> all() {
        return ExtensionList.lookup(BluePipelineFactory.class);
    }

    public static Resource resolve(Item item) {
        BlueOrganization org = OrganizationFactory.getInstance().getContainingOrg(item);
        Item nextStep = BluePipelineFactory.findNextStep((ItemGroup)Jenkins.getInstance(), item);
        for (BluePipelineFactory f : BluePipelineFactory.all()) {
            Resource r = f.resolve(nextStep, org.getPipelines(), item);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    @SuppressFBWarnings(value={"EC_UNRELATED_TYPES_USING_POINTER_EQUALITY"}, justification="Folder/MBP etc. are Item and ItemGroup")
    protected static Item findNextStep(ItemGroup context, Item target) {
        Item i = null;
        while (context != target) {
            i = target;
            if (!(target.getParent() instanceof Item)) break;
            target = (Item)target.getParent();
        }
        return i == null ? target : i;
    }

    public static BluePipeline getPipelineInstance(Item item, Reachable parent) {
        if (!(item instanceof TopLevelItem)) {
            return null;
        }
        for (BluePipelineFactory factory : BluePipelineFactory.all()) {
            BluePipeline pipeline = factory.getPipeline(item, parent);
            if (pipeline == null) continue;
            return pipeline;
        }
        return null;
    }
}

