/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest;

import com.google.common.collect.ImmutableMap;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Utils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.Converter;

public class Query {
    public final String type;
    private final Map<String, String> params;

    private Query(String type, Map<String, String> values) {
        this.type = type;
        this.params = values == null ? ImmutableMap.of() : ImmutableMap.copyOf(values);
    }

    public String param(String key) {
        return this.params.get(key.toLowerCase());
    }

    public String param(String key, boolean required) {
        return this.param(key, String.class, required);
    }

    public <T> T param(String key, Class<T> type) {
        return this.param(key, type, false);
    }

    public <T> T param(String key, Class<T> type, boolean required) {
        String value = this.params.get(key);
        if (value == null && required) {
            throw new ServiceException.BadRequestException(String.format("%s is required parameter to execute query for type %s", key, type));
        }
        if (value == null && Boolean.class.isAssignableFrom(type)) {
            return (T)Boolean.FALSE;
        }
        if (value == null) {
            return null;
        }
        return Utils.cast(value, type);
    }

    public static Query parse(String query) {
        String[] values = query.split(";");
        String type = null;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String v : values) {
            String[] vv = v.split(":");
            if (vv.length != 2) continue;
            String key = vv[0].trim().toLowerCase();
            String value = vv[1].trim();
            if (key.equals("type")) {
                type = value.toLowerCase();
                continue;
            }
            params.put(key, value);
        }
        if (type == null) {
            throw new ServiceException.BadRequestException("type is required parameter for query param q");
        }
        return new Query(type, params);
    }

    public static class StaplerConverterImpl
    implements Converter {
        public Object convert(Class type, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return Query.parse((String)value);
            }
            throw new UnsupportedOperationException();
        }
    }
}

