/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.commons.stapler.TreeResponse;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueArtifactContainer;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Resource;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.verb.POST;
import org.kohsuke.stapler.verb.PUT;

@Capability(value={"io.jenkins.blueocean.rest.model.BlueRun"})
public abstract class BlueRun
extends Resource {
    public static final String ORGANIZATION = "organization";
    public static final String ID = "id";
    public static final String PIPELINE = "pipeline";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String ENQUEUE_TIME = "enQueueTime";
    public static final String DURATION_IN_MILLIS = "durationInMillis";
    public static final String ESTIMATED_DURATION_IN_MILLIS = "estimatedDurationInMillis";
    public static final String TYPE = "type";
    public static final String RUN_SUMMARY = "runSummary";
    public static final String RESULT = "result";
    public static final String STATE = "state";
    public static final String CAUSE_OF_BLOCKAGE = "causeOfBlockage";
    public static final String REPLAYABLE = "replayable";
    public static final String TEST_SUMMARY = "testSummary";
    public static final String ACTIONS = "actions";
    public static final String CAUSES = "causes";
    public static final int DEFAULT_BLOCKING_STOP_TIMEOUT_IN_SECS = 10;
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    @Exported(name="organization")
    public abstract String getOrganization();

    @Exported(name="id")
    public abstract String getId();

    @Exported(name="pipeline")
    public abstract String getPipeline();

    @Exported(name="name")
    public abstract String getName();

    @Exported(name="description")
    public abstract String getDescription();

    public abstract Date getStartTime();

    @Exported(inline=true)
    public abstract Container<BlueChangeSetEntry> getChangeSet();

    @Exported(name="startTime")
    public final String getStartTimeString() {
        return new SimpleDateFormat(DATE_FORMAT_STRING).format(this.getStartTime());
    }

    public abstract Date getEnQueueTime();

    @Exported(name="enQueueTime")
    public final String getEnQueueTimeString() {
        return new SimpleDateFormat(DATE_FORMAT_STRING).format(this.getEnQueueTime());
    }

    public abstract Date getEndTime();

    @Exported(name="endTime")
    public final String getEndTimeString() {
        Date endTime = this.getEndTime();
        if (endTime == null) {
            return null;
        }
        return new SimpleDateFormat(DATE_FORMAT_STRING).format(endTime);
    }

    @Exported(name="durationInMillis")
    public abstract Long getDurationInMillis();

    @Exported(name="estimatedDurationInMillis")
    public abstract Long getEstimatedDurtionInMillis();

    @Exported(name="state")
    public abstract BlueRunState getStateObj();

    @Exported(name="result")
    public abstract BlueRunResult getResult();

    @Exported(name="runSummary")
    public abstract String getRunSummary();

    @Exported(name="type")
    public abstract String getType();

    @PUT
    @TreeResponse
    @WebMethod(name={"stop"})
    public abstract BlueRun stop(@QueryParameter(value="blocking") Boolean var1, @QueryParameter(value="timeOutInSecs") Integer var2);

    @Exported
    public abstract String getArtifactsZipFile();

    @Navigable
    public abstract BlueArtifactContainer getArtifacts();

    public abstract BluePipelineNodeContainer getNodes();

    @Navigable
    @Exported(name="actions", inline=true)
    public abstract Collection<BlueActionProxy> getActions();

    public abstract BluePipelineStepContainer getSteps();

    @Navigable
    public abstract BlueTestResultContainer getTests();

    @Exported(name="testSummary", inline=true, skipNull=true)
    public abstract BlueTestSummary getTestSummary();

    @Navigable
    public abstract Object getLog();

    @POST
    @TreeResponse
    @WebMethod(name={"replay"})
    public abstract BlueRun replay();

    @Exported(name="causes", inline=true)
    public abstract Collection<BlueCause> getCauses();

    @Exported(name="causeOfBlockage")
    public abstract String getCauseOfBlockage();

    @Exported(name="replayable")
    public abstract boolean isReplayable();

    public static enum BlueRunResult {
        SUCCESS,
        UNSTABLE,
        FAILURE,
        NOT_BUILT,
        UNKNOWN,
        ABORTED;

    }

    public static enum BlueRunState {
        QUEUED,
        RUNNING,
        PAUSED,
        SKIPPED,
        NOT_BUILT,
        FINISHED;

    }

    @ExportedBean
    public static abstract class BlueCause {
        public abstract String getShortDescription();

        @Exported(name="cause", merge=true)
        public abstract Object getCause();
    }
}

