/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.commons.stapler.TreeResponse;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BluePipelineScm;
import io.jenkins.blueocean.rest.model.BluePipelineUpdateRequest;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.Resource;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.verb.PUT;

@Capability(value={"io.jenkins.blueocean.rest.model.BluePipeline"})
public abstract class BluePipeline
extends Resource {
    public static final String ORGANIZATION = "organization";
    public static final String NAME = "name";
    public static final String DISPLAY_NAME = "displayName";
    public static final String FULL_NAME = "fullName";
    public static final String FULL_DISPLAY_NAME = "fullDisplayName";
    public static final String WEATHER_SCORE = "weatherScore";
    public static final String LATEST_RUN = "latestRun";
    public static final String ESTIMATED_DURATION = "estimatedDurationInMillis";
    public static final String ACTIONS = "actions";
    public static final String PERMISSIONS = "permissions";
    public static final String CREATE_PERMISSION = "create";
    public static final String READ_PERMISSION = "read";
    public static final String START_PERMISSION = "start";
    public static final String STOP_PERMISSION = "stop";
    public static final String CONFIGURE_PERMISSION = "configure";
    private static final String PARAMETERS = "parameters";

    @Exported(name="organization")
    public abstract String getOrganization();

    @Exported(name="name")
    public abstract String getName();

    @Exported(name="displayName")
    public abstract String getDisplayName();

    @Exported(name="fullName")
    public abstract String getFullName();

    @Exported(name="fullDisplayName")
    public abstract String getFullDisplayName();

    @Exported(name="weatherScore")
    public abstract Integer getWeatherScore();

    @Exported(name="latestRun", inline=true)
    public abstract BlueRun getLatestRun();

    @Exported(name="estimatedDurationInMillis")
    public abstract Long getEstimatedDurationInMillis();

    @Navigable
    public abstract BlueRunContainer getRuns();

    @Navigable
    @Exported(name="actions", inline=true)
    public abstract Collection<BlueActionProxy> getActions();

    @Navigable
    public abstract BlueQueueContainer getQueue();

    @Exported(name="parameters", inline=true)
    public abstract List<Object> getParameters();

    @PUT
    @WebMethod(name={"favorite"})
    @TreeResponse
    public abstract BlueFavorite favorite(@JsonBody BlueFavoriteAction var1);

    @Exported(name="permissions")
    public abstract Map<String, Boolean> getPermissions();

    @PUT
    @WebMethod(name={""})
    @TreeResponse
    public BluePipeline update(StaplerRequest staplerRequest) throws IOException {
        JSONObject body = JSONObject.fromObject((Object)IOUtils.toString((Reader)staplerRequest.getReader()));
        if (body.get("$class") == null) {
            throw new ServiceException.BadRequestExpception("$class is required element");
        }
        BluePipelineUpdateRequest request = (BluePipelineUpdateRequest)staplerRequest.bindJSON(BluePipelineUpdateRequest.class, body);
        return this.update(request);
    }

    public BluePipeline update(BluePipelineUpdateRequest request) throws IOException {
        return request.update(this);
    }

    public abstract BluePipelineScm getScm();
}

