/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.factory;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class OrganizationResolver
implements ExtensionPoint {
    public abstract BlueOrganization get(String var1);

    public abstract Collection<BlueOrganization> list();

    public abstract BlueOrganization of(ItemGroup var1);

    public BlueOrganization getContainingOrg(ItemGroup p) {
        while (true) {
            BlueOrganization n;
            if ((n = this.of(p)) != null) {
                return n;
            }
            if (!(p instanceof Item)) break;
            p = ((Item)p).getParent();
        }
        return null;
    }

    public final BlueOrganization getContainingOrg(Run r) {
        return this.getContainingOrg((Item)r.getParent());
    }

    public final BlueOrganization getContainingOrg(Item i) {
        if (i instanceof ItemGroup) {
            return this.getContainingOrg((ItemGroup)i);
        }
        return this.getContainingOrg(i.getParent());
    }

    public static OrganizationResolver getInstance() {
        OrganizationResolver r = (OrganizationResolver)ExtensionList.lookup(OrganizationResolver.class).get(0);
        if (r == null) {
            throw new AssertionError((Object)"No OrganizationResolver is installed");
        }
        return r;
    }

    @Nullable
    public static ItemGroup<? extends Item> getItemGroup(String org) {
        BlueOrganization blueOrganization = OrganizationResolver.getInstance().get(org);
        if (blueOrganization instanceof ItemGroupProvider) {
            return ((ItemGroupProvider)((Object)blueOrganization)).getGroup();
        }
        return null;
    }

    public static interface ItemGroupProvider {
        public ItemGroup getGroup();
    }
}

