/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import io.jenkins.blueocean.BlueOceanUIProvider;
import io.jenkins.blueocean.RootRoutable;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.ApiRoutable;
import io.jenkins.blueocean.rest.OmniSearch;
import io.jenkins.blueocean.rest.Query;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.pageable.Pageable;
import io.jenkins.blueocean.rest.pageable.Pageables;
import io.jenkins.blueocean.rest.pageable.PagedResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.GET;

@Extension
public final class ApiHead
implements RootRoutable,
Reachable {
    private volatile BlueOceanUIProvider blueOceanUI;
    private volatile Map<String, ApiRoutable> apis;
    public static final String URL_NAME = "rest";

    public ApiHead() {
        ExtensionList.lookup(ApiRoutable.class).addListener(new ExtensionListListener(){

            public void onChange() {
                ApiHead.this.recomputeApis();
            }
        });
    }

    @WebMethod(name={"search"})
    @GET
    @PagedResponse
    public Pageable<?> search(@QueryParameter(value="q") Query query) {
        for (OmniSearch os : OmniSearch.all()) {
            if (!os.getType().equals(query.type)) continue;
            return os.search(query);
        }
        return Pageables.empty();
    }

    @Override
    public String getUrlName() {
        return URL_NAME;
    }

    public ApiRoutable getDynamic(String route) {
        String header;
        this.setApis();
        StaplerRequest request = Stapler.getCurrentRequest();
        String m = request.getMethod();
        if ((m.equalsIgnoreCase("POST") || m.equalsIgnoreCase("PUT") || m.equalsIgnoreCase("PATCH")) && ((header = request.getHeader("Content-Type")) == null || !header.contains("application/json"))) {
            throw new ServiceException(415, "Content-Type: application/json required");
        }
        return this.apis.get(route);
    }

    @Override
    public Link getLink() {
        this.setBlueOceanUI();
        return new Link("/" + this.blueOceanUI.getUrlBasePrefix()).rel(this.getUrlName());
    }

    public static ApiHead INSTANCE() {
        ExtensionList extensionList = ExtensionList.lookup(ApiHead.class);
        if (!extensionList.isEmpty()) {
            return (ApiHead)extensionList.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBlueOceanUI() {
        BlueOceanUIProvider boui = this.blueOceanUI;
        if (boui == null) {
            ApiHead apiHead = this;
            synchronized (apiHead) {
                boui = this.blueOceanUI;
                if (boui == null) {
                    this.blueOceanUI = boui = this.getUiProvider();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setApis() {
        Map<String, ApiRoutable> apiMap = this.apis;
        if (apiMap == null) {
            ApiHead apiHead = this;
            synchronized (apiHead) {
                apiMap = this.apis;
                if (apiMap == null) {
                    this.recomputeApis();
                }
            }
        }
    }

    private void recomputeApis() {
        HashMap<String, ApiRoutable> apiMap = new HashMap<String, ApiRoutable>();
        for (ApiRoutable api : ExtensionList.lookup(ApiRoutable.class)) {
            String n = api.getUrlName();
            if (apiMap.containsKey(n)) continue;
            apiMap.put(n, api);
        }
        this.apis = apiMap;
    }

    private BlueOceanUIProvider getUiProvider() {
        Iterator iterator = BlueOceanUIProvider.all().iterator();
        if (iterator.hasNext()) {
            BlueOceanUIProvider provider = (BlueOceanUIProvider)iterator.next();
            return provider;
        }
        return null;
    }
}

