/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.pageable;

import com.google.common.collect.Iterators;
import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.rest.pageable.Pageable;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.CancelRequestHandlingException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.Interceptor;
import org.kohsuke.stapler.interceptor.InterceptorAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@InterceptorAnnotation(value=Processor.class)
public @interface PagedResponse {

    public static class Processor
    extends Interceptor {
        private static final int DEFAULT_LIMIT = 100;

        public Object invoke(StaplerRequest request, StaplerResponse response, Object instance, Object[] arguments) throws IllegalAccessException, InvocationTargetException, ServletException {
            String method = request.getMethod();
            if (!method.equalsIgnoreCase("GET")) {
                throw new CancelRequestHandlingException();
            }
            final Pageable resp = (Pageable)this.target.invoke(request, response, instance, arguments);
            return new HttpResponse(){

                public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                    int limit;
                    int start = req.getParameter("start") != null ? Integer.parseInt(req.getParameter("start")) : 0;
                    int n = limit = req.getParameter("limit") != null ? Integer.parseInt(req.getParameter("limit")) : 100;
                    if (start < 0) {
                        start = 0;
                    }
                    if (limit < 0) {
                        limit = 100;
                    }
                    Object[] page = Iterators.toArray(resp.iterator(start, limit), Object.class);
                    String separator = req.getQueryString() != null ? "&" : "?";
                    rsp.setHeader("Link", "<" + req.getRequestURIWithQueryString() + separator + "start=" + (start + limit) + "&limit=" + limit + ">; rel=\"next\"");
                    Export.doJson((StaplerRequest)req, (StaplerResponse)rsp, (Object)page);
                }
            };
        }
    }
}

