/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BluePipelineFolder;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

@Capability(value={"io.jenkins.blueocean.rest.model.BlueMultiBranchPipeline"})
public abstract class BlueMultiBranchPipeline
extends BluePipelineFolder {
    public static final String TOTAL_NUMBER_OF_BRANCHES = "totalNumberOfBranches";
    public static final String NUMBER_OF_FAILING_BRANCHES = "numberOfFailingBranches";
    public static final String NUMBER_OF_SUCCESSFULT_BRANCHES = "numberOfSuccessfulBranches";
    public static final String TOTAL_NUMBER_OF_PULL_REQUESTS = "totalNumberOfPullRequests";
    public static final String NUMBER_OF_FAILING_PULL_REQUESTS = "numberOfFailingPullRequests";
    public static final String NUMBER_OF_SUCCESSFULT_PULL_REQUESTS = "numberOfSuccessfulPullRequests";
    public static final String BRANCH_NAMES = "branchNames";

    @Exported(name="totalNumberOfBranches")
    public abstract int getTotalNumberOfBranches();

    @Exported(name="numberOfFailingBranches")
    public abstract int getNumberOfFailingBranches();

    @Exported(name="numberOfSuccessfulBranches")
    public abstract int getNumberOfSuccessfulBranches();

    @Exported(name="totalNumberOfPullRequests")
    public abstract int getTotalNumberOfPullRequests();

    @Exported(name="numberOfFailingPullRequests")
    public abstract int getNumberOfFailingPullRequests();

    @Exported(name="numberOfSuccessfulPullRequests")
    public abstract int getNumberOfSuccessfulPullRequests();

    public abstract BluePipelineContainer getBranches();

    @Exported(name="branchNames")
    public abstract Collection<String> getBranchNames();

    @Override
    public BlueRunContainer getRuns() {
        return new BlueRunContainer(){

            @Override
            public Link getLink() {
                return null;
            }

            @Override
            public BlueRun get(String name) {
                throw new ServiceException.NotFoundException(String.format("It is multi-branch project. No run with name: %s found.", name));
            }

            @Override
            public Iterator<BlueRun> iterator() {
                return Collections.emptyIterator();
            }

            @Override
            public BlueQueueItem create(StaplerRequest request) {
                throw new ServiceException.NotImplementedException("This action is not supported");
            }
        };
    }
}

