/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.hal;

import io.jenkins.blueocean.rest.hal.Links;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=99999)
public final class Link {
    private final String href;

    public Link(String href) {
        this.href = Links.ensureTrailingSlash(href);
        assert (this.href.endsWith("/"));
    }

    @Exported(name="href")
    public String getHref() {
        return this.href;
    }

    public Link rel(String name) {
        return new Link(this.href + name);
    }

    public Link ancestor() {
        int j;
        int i = this.href.lastIndexOf("/");
        if (i > 0 && (j = this.href.substring(0, i).lastIndexOf("/")) > 0) {
            return new Link(this.href.substring(0, j));
        }
        return new Link("/");
    }

    public String toString() {
        return this.href;
    }
}

