/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueInputStep;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.Resource;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.kohsuke.stapler.export.Exported;

@Capability(value={"io.jenkins.blueocean.rest.model.BluePipelineStep"})
public abstract class BluePipelineStep
extends Resource {
    public static final String DISPLAY_NAME = "displayName";
    public static final String RESULT = "result";
    public static final String START_TIME = "startTime";
    public static final String ID = "id";
    public static final String EDGES = "edges";
    public static final String DURATION_IN_MILLIS = "durationInMillis";
    public static final String ACTIONS = "actions";

    @Exported(name="id")
    public abstract String getId();

    @Exported(name="displayName")
    public abstract String getDisplayName();

    @Exported(name="result")
    public abstract BlueRun.BlueRunResult getResult();

    @Exported(name="state")
    public abstract BlueRun.BlueRunState getStateObj();

    public abstract Date getStartTime();

    @Exported(name="startTime")
    public final String getStartTimeString() {
        if (this.getStartTime() == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(this.getStartTime());
    }

    @Exported(name="durationInMillis")
    public abstract Long getDurationInMillis();

    public abstract Object getLog();

    @Navigable
    @Exported(name="actions", inline=true)
    public abstract Collection<BlueActionProxy> getActions();

    @Exported(name="input", inline=true)
    public abstract BlueInputStep getInputStep();
}

