/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.commons.stapler.TreeResponse;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Resource;
import java.util.Collection;
import java.util.Map;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.verb.PUT;

@Capability(value={"io.jenkins.blueocean.rest.model.BluePipeline"})
public abstract class BluePipeline
extends Resource {
    public static final String ORGANIZATION = "organization";
    public static final String NAME = "name";
    public static final String DISPLAY_NAME = "displayName";
    public static final String FULL_NAME = "fullName";
    public static final String FULL_DISPLAY_NAME = "fullDisplayName";
    public static final String WEATHER_SCORE = "weatherScore";
    public static final String LATEST_RUN = "latestRun";
    public static final String ESTIMATED_DURATION = "estimatedDurationInMillis";
    public static final String LAST_SUCCESSFUL_RUN = "lastSuccessfulRun";
    public static final String ACTIONS = "actions";
    public static final String PERMISSIONS = "permissions";
    public static final String CREATE_PERMISSION = "create";
    public static final String READ_PERMISSION = "read";
    public static final String START_PERMISSION = "start";
    public static final String STOP_PERMISSION = "stop";

    @Exported(name="organization")
    public abstract String getOrganization();

    @Exported(name="name")
    public abstract String getName();

    @Exported(name="displayName")
    public abstract String getDisplayName();

    @Exported(name="fullName")
    public abstract String getFullName();

    @Exported(name="fullDisplayName")
    public abstract String getFullDisplayName();

    @Exported(name="weatherScore")
    public abstract Integer getWeatherScore();

    @Exported(name="latestRun", inline=true)
    public abstract BlueRun getLatestRun();

    @Exported(name="lastSuccessfulRun")
    public abstract String getLastSuccessfulRun();

    @Exported(name="estimatedDurationInMillis")
    public abstract Long getEstimatedDurationInMillis();

    @Navigable
    public abstract BlueRunContainer getRuns();

    @Navigable
    @Exported(name="actions", inline=true)
    public abstract Collection<BlueActionProxy> getActions();

    @Navigable
    public abstract BlueQueueContainer getQueue();

    @Navigable
    public abstract Container<Resource> getActivities();

    @PUT
    @WebMethod(name={"favorite"})
    @TreeResponse
    public abstract BlueFavorite favorite(@JsonBody BlueFavoriteAction var1);

    @Exported(name="permissions")
    public abstract Map<String, Boolean> getPermissions();
}

