/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.pageable;

import com.google.common.collect.Iterators;
import io.jenkins.blueocean.rest.pageable.Pageable;
import java.util.Collections;
import java.util.Iterator;

public abstract class Pageables {
    private Pageables() {
    }

    public static <T> Pageable<T> empty() {
        return Pageables.wrap(Collections.emptyList());
    }

    public static <T> Iterator<T> slice(Iterator<T> base, int start, int limit) {
        if (Iterators.skip(base, (int)start) != start) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Iterators.limit(base, (int)limit);
    }

    public static <T> Pageable<T> wrap(final Iterable<T> base) {
        return new Pageable<T>(){

            @Override
            public Iterator<T> iterator(int start, int limit) {
                return Pageables.slice(this.iterator(), start, limit);
            }

            @Override
            public Iterator<T> iterator() {
                return base.iterator();
            }
        };
    }
}

