/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import hudson.model.Action;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.ExportedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionProxiesImpl
extends BlueActionProxy {
    private final Action action;
    private final Reachable parent;
    private static final Logger logger = LoggerFactory.getLogger(ActionProxiesImpl.class);

    public ActionProxiesImpl(Action action, Reachable parent) {
        this.action = action;
        this.parent = parent;
    }

    public Object getAction() {
        if (this.action.getClass().isAnnotationPresent(ExportedBean.class)) {
            return this.action;
        }
        return null;
    }

    public String getUrlName() {
        try {
            return this.action.getUrlName();
        }
        catch (Exception e) {
            logger.error(String.format("Error calling %s.getUrlName(): %s", this.action.getClass().getName(), e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String get_Class() {
        return this.action.getClass().getName();
    }

    public Link getLink() {
        if (this.getUrlName() != null) {
            return this.parent.getLink().rel(this.getUrlName());
        }
        return null;
    }

    public static Collection<BlueActionProxy> getActionProxies(List<? extends Action> actions, Reachable parent) {
        if (ActionProxiesImpl.isTreeRequest()) {
            return ActionProxiesImpl.getActionProxies(actions, (Predicate<Action>)Predicates.alwaysFalse(), parent);
        }
        return Collections.emptyList();
    }

    public static Collection<BlueActionProxy> getActionProxies(List<? extends Action> actions, final Predicate<Action> alwaysAllowAction, Reachable parent) {
        ArrayList<BlueActionProxy> actionProxies = new ArrayList<BlueActionProxy>();
        for (Action action : Iterables.filter(actions, (Predicate)new Predicate<Action>(){

            public boolean apply(Action action) {
                return action != null && (action.getClass().getAnnotation(ExportedBean.class) != null || alwaysAllowAction.apply((Object)action));
            }
        })) {
            actionProxies.add(new ActionProxiesImpl(action, parent));
        }
        return actionProxies;
    }

    private static boolean isTreeRequest() {
        return StringUtils.isNotBlank((String)Stapler.getCurrentRequest().getParameter("tree"));
    }
}

