/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.analytics;

import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import io.jenkins.blueocean.analytics.Analytics;
import io.jenkins.blueocean.service.embedded.analytics.JobAnalyticsCheck;
import io.jenkins.blueocean.service.embedded.analytics.JobAnalyticsExclude;
import io.jenkins.blueocean.service.embedded.analytics.Tally;
import java.io.IOException;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public final class JobAnalytics
extends AsyncPeriodicWork {
    private static final String JOB_STATS_EVENT_NAME = "job_stats";
    private static final String OTHER_CATEGORY = "other";

    public JobAnalytics() {
        super("jobAnalytics");
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        this.calculateAndSend();
    }

    public void calculateAndSend() {
        Analytics analytics = Analytics.get();
        if (analytics == null) {
            return;
        }
        Jenkins jenkins = Jenkins.getInstance();
        ExtensionList checks = ExtensionList.lookup(JobAnalyticsCheck.class);
        ExtensionList excludes = ExtensionList.lookup(JobAnalyticsExclude.class);
        Tally tally = new Tally();
        checks.forEach(check -> tally.zero(check.getName()));
        tally.zero(OTHER_CATEGORY);
        jenkins.allItems().forEach(item -> {
            if (excludes.stream().noneMatch(exclude -> (Boolean)exclude.apply(item))) {
                boolean matchFound = false;
                for (JobAnalyticsCheck check : checks) {
                    if (!((Boolean)check.apply(item)).booleanValue()) continue;
                    tally.count(check.getName());
                    matchFound = true;
                    break;
                }
                if (!matchFound) {
                    tally.count(OTHER_CATEGORY);
                }
            }
        });
        analytics.track(new Analytics.TrackRequest(JOB_STATS_EVENT_NAME, (Map)ImmutableMap.copyOf(tally.get())));
    }

    public long getRecurrencePeriod() {
        return 86400000L;
    }
}

