// CHECKSTYLE:OFF

package io.jenkins.blueocean.service.embedded;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BlueOceanUrlAction.DisplayName}: {@code Open Blue Ocean}.
     * 
     * @return
     *     {@code Open Blue Ocean}
     */
    public static String BlueOceanUrlAction_DisplayName() {
        return holder.format("BlueOceanUrlAction.DisplayName");
    }

    /**
     * Key {@code BlueOceanUrlAction.DisplayName}: {@code Open Blue Ocean}.
     * 
     * @return
     *     {@code Open Blue Ocean}
     */
    public static Localizable _BlueOceanUrlAction_DisplayName() {
        return new Localizable(holder, "BlueOceanUrlAction.DisplayName");
    }

    /**
     * Key {@code BlueOceanUrlAction.GenericDisplayName}: {@code Open Blue
     * Ocean Homepage}.
     * 
     * @return
     *     {@code Open Blue Ocean Homepage}
     */
    public static String BlueOceanUrlAction_GenericDisplayName() {
        return holder.format("BlueOceanUrlAction.GenericDisplayName");
    }

    /**
     * Key {@code BlueOceanUrlAction.GenericDisplayName}: {@code Open Blue
     * Ocean Homepage}.
     * 
     * @return
     *     {@code Open Blue Ocean Homepage}
     */
    public static Localizable _BlueOceanUrlAction_GenericDisplayName() {
        return new Localizable(holder, "BlueOceanUrlAction.GenericDisplayName");
    }

}
