/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.util;

import hudson.model.Item;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueFavoriteResolver;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.service.embedded.rest.FavoriteImpl;
import io.jenkins.blueocean.service.embedded.util.Capabilities;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Nonnull;

public class FavoriteUtil {
    public static void toggle(BlueFavoriteAction action, Item item) {
        if (action.isFavorite().booleanValue()) {
            try {
                Favorites.addFavorite((User)FavoriteUtil.getUser(), (Item)item);
            }
            catch (Favorites.FavoriteException e) {
                throw new ServiceException.UnexpectedErrorException("Something went wrong setting the favorite", (Throwable)e);
            }
        }
        try {
            Favorites.removeFavorite((User)FavoriteUtil.getUser(), (Item)item);
        }
        catch (Favorites.FavoriteException e) {
            throw new ServiceException.UnexpectedErrorException("Something went wrong removing the favorite", (Throwable)e);
        }
    }

    public static String decodeFullName(String name) {
        try {
            return URLDecoder.decode(URLDecoder.decode(name, "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException.UnexpectedErrorException("Something went wrong URL decoding fullName: " + name, (Throwable)e);
        }
    }

    public static BlueFavorite getFavorite(Item item) {
        final Link l = LinkResolver.resolveLink((Object)item);
        if (l != null) {
            return FavoriteUtil.getFavorite(item, new Reachable(){

                public Link getLink() {
                    return l.ancestor();
                }
            });
        }
        return null;
    }

    public static BlueFavorite getFavorite(Item item, @Nonnull Reachable parent) {
        if (item == null) {
            return null;
        }
        for (BlueFavoriteResolver resolver : BlueFavoriteResolver.all()) {
            BlueFavorite blueFavorite = resolver.resolve(item, parent);
            if (blueFavorite == null) continue;
            return blueFavorite;
        }
        BluePipeline pipeline = BluePipelineFactory.getPipelineInstance((Item)item, (Reachable)parent);
        if (pipeline != null && !Capabilities.hasCapability(pipeline, "io.jenkins.blueocean.rest.model.NoFavorite")) {
            return new FavoriteImpl(pipeline, pipeline.getLink().rel("favorite"));
        }
        return null;
    }

    private static User getUser() {
        User user = User.current();
        if (user == null) {
            throw new ServiceException.ForbiddenException("Must be logged in to use set favorites");
        }
        return user;
    }
}

