/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.ScheduleResult;
import hudson.util.RunList;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueRunFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.service.embedded.rest.QueueItemImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueUtil;
import io.jenkins.blueocean.service.embedded.rest.RunSearch;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;

public class RunContainerImpl
extends BlueRunContainer {
    private final Job job;
    private final BluePipeline pipeline;

    public RunContainerImpl(@Nonnull BluePipeline pipeline, @Nonnull Job job) {
        this.job = job;
        this.pipeline = pipeline;
    }

    public Link getLink() {
        return this.pipeline.getLink().rel("runs");
    }

    public BlueRun get(String name) {
        int number;
        RunList runList = this.job.getBuilds();
        if (name == null) {
            return BlueRunFactory.getRun((Run)runList.getLastBuild(), (Reachable)this.pipeline);
        }
        for (Run r : runList) {
            if (!r.getId().equals(name)) continue;
            return BlueRunFactory.getRun((Run)r, (Reachable)this.pipeline);
        }
        try {
            number = Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            throw new ServiceException.NotFoundException(String.format("Run %s not found in organization %s and pipeline %s", name, this.pipeline.getOrganizationName(), this.job.getName()));
        }
        for (BlueQueueItem item : QueueUtil.getQueuedItems(this.pipeline.getOrganization(), this.job)) {
            if (item.getExpectedBuildNumber() != number) continue;
            return item.toRun();
        }
        throw new ServiceException.NotFoundException(String.format("Run %s not found in organization %s and pipeline %s", name, this.pipeline.getOrganizationName(), this.job.getName()));
    }

    public Iterator<BlueRun> iterator() {
        return this.getRuns(RunSearch.findRuns(this.job, this.pipeline.getLink()));
    }

    public Iterator<BlueRun> iterator(int start, int limit) {
        return this.getRuns(RunSearch.findRuns(this.job, this.pipeline.getLink(), start, limit));
    }

    private Iterator<BlueRun> getRuns(Iterable<BlueRun> runs) {
        return Iterables.concat((Iterable)Iterables.transform(QueueUtil.getQueuedItems(this.pipeline.getOrganization(), this.job), (Function)new Function<BlueQueueItem, BlueRun>(){

            public BlueRun apply(BlueQueueItem input) {
                return input.toRun();
            }
        }), runs).iterator();
    }

    public BlueRun create(StaplerRequest request) {
        this.job.checkPermission(Item.BUILD);
        if (this.job instanceof Queue.Task) {
            List<ParameterValue> parameterValues = this.getParameterValue(request);
            int expectedBuildNumber = this.job.getNextBuildNumber();
            ScheduleResult scheduleResult = parameterValues.size() > 0 ? Jenkins.getInstance().getQueue().schedule2((Queue.Task)this.job, 0, new Action[]{new ParametersAction(parameterValues), new CauseAction((Cause)new Cause.UserIdCause())}) : Jenkins.getInstance().getQueue().schedule2((Queue.Task)this.job, 0, new Action[]{new CauseAction((Cause)new Cause.UserIdCause())});
            Queue.Item item = scheduleResult.getItem();
            if (scheduleResult.isAccepted() && item != null) {
                return new QueueItemImpl(this.pipeline.getOrganization(), item, this.pipeline, expectedBuildNumber, this.pipeline.getLink().rel("queue").rel(Long.toString(item.getId())), this.pipeline.getLink()).toRun();
            }
            throw new ServiceException.UnexpectedErrorException("Queue item request was not accepted");
        }
        throw new ServiceException.NotImplementedException("This pipeline type does not support being queued.");
    }

    private List<ParameterValue> getParameterValue(@Nonnull StaplerRequest request) {
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        ArrayList<ParameterDefinition> pdsInRequest = new ArrayList<ParameterDefinition>();
        ParametersDefinitionProperty pp = (ParametersDefinitionProperty)this.job.getProperty(ParametersDefinitionProperty.class);
        if (pp == null) {
            return values;
        }
        try {
            JSONObject body = JSONObject.fromObject((Object)IOUtils.toString((Reader)request.getReader()));
            if (body.get("parameters") == null && pp.getParameterDefinitions().size() > 0) {
                throw new ServiceException.BadRequestException("This is parameterized job, requires parameters");
            }
            if (body.get("parameters") != null) {
                JSONArray pds = JSONArray.fromObject((Object)body.get("parameters"));
                for (Object o : pds) {
                    JSONObject p = (JSONObject)o;
                    String name = (String)p.get("name");
                    if (name == null) {
                        throw new ServiceException.BadRequestException("parameters.name is required element");
                    }
                    ParameterDefinition pd = pp.getParameterDefinition(name);
                    if (pd == null) {
                        throw new ServiceException.BadRequestException("No such parameter definition: " + name);
                    }
                    ParameterValue parameterValue = pd.createValue(request, p);
                    if (parameterValue != null) {
                        values.add(parameterValue);
                        pdsInRequest.add(pd);
                        continue;
                    }
                    throw new ServiceException.BadRequestException("Invalid value. Cannot retrieve the parameter value: " + name);
                }
                if (pdsInRequest.size() != pp.getParameterDefinitions().size()) {
                    for (ParameterDefinition pd : pp.getParameterDefinitions()) {
                        if (pdsInRequest.contains(pd)) continue;
                        ParameterValue v = pd.getDefaultParameterValue();
                        if (v == null || v.getValue() == null) {
                            throw new ServiceException.BadRequestException("Missing parameter: " + pd.getName());
                        }
                        values.add(v);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
        return values;
    }
}

