/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.Queue;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.Links;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.FreeStylePipeline;
import io.jenkins.blueocean.service.embedded.rest.QueuedBlueRun;
import io.jenkins.blueocean.service.embedded.rest.QueuedFreeStyleRun;
import java.util.Collection;
import java.util.Date;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;

public class QueueItemImpl
extends BlueQueueItem {
    private final Queue.Item item;
    private final Link self;
    private final Link parent;
    private final int expectedBuildNumber;
    private final BlueOrganization organization;
    private final BluePipeline pipeline;

    public QueueItemImpl(BlueOrganization organization, Queue.Item item, BluePipeline pipeline, int expectedBuildNumber) {
        this(organization, item, pipeline, expectedBuildNumber, pipeline.getQueue().getLink().rel(Long.toString(item.getId())), pipeline.getLink());
    }

    QueueItemImpl(BlueOrganization organization, Queue.Item item, BluePipeline pipeline, int expectedBuildNumber, Link self, Link parent) {
        this.organization = organization;
        this.item = item;
        this.pipeline = pipeline;
        this.expectedBuildNumber = expectedBuildNumber;
        this.self = self;
        this.parent = parent;
    }

    public String getId() {
        return Long.toString(this.item.getId());
    }

    public String getOrganization() {
        return this.organization.getName();
    }

    public String getPipeline() {
        return this.pipeline.getName();
    }

    public Date getQueuedTime() {
        return new Date(this.item.getInQueueSince());
    }

    @Exported(name="queuedTime")
    public String getQueuedTimeString() {
        return AbstractRunImpl.DATE_FORMAT.format(this.getQueuedTime().toInstant());
    }

    public int getExpectedBuildNumber() {
        return this.expectedBuildNumber;
    }

    public void delete() {
        if (!this.item.hasCancelPermission()) {
            throw new ServiceException.ForbiddenException(String.format("Not authorized to stop queue: %s", this.getId()));
        }
        Jenkins.getInstance().getQueue().cancel(this.item);
    }

    public Collection<BlueRun.BlueCause> getCauses() {
        return AbstractRunImpl.BlueCauseImpl.getCauses(this.item.getCauses());
    }

    public String getCauseOfBlockage() {
        return this.item.getCauseOfBlockage().toString();
    }

    public BlueRun toRun() {
        if (this.pipeline instanceof FreeStylePipeline) {
            return new QueuedFreeStyleRun(BlueRun.BlueRunState.QUEUED, BlueRun.BlueRunResult.UNKNOWN, this, this.parent);
        }
        return new QueuedBlueRun(BlueRun.BlueRunState.QUEUED, BlueRun.BlueRunResult.UNKNOWN, this, this.parent);
    }

    public Link getLink() {
        return this.self;
    }

    public Links getLinks() {
        return super.getLinks().add("parent", this.parent);
    }
}

