/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueIssueFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueIssue;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BlueUser;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ChangeSetResource
extends BlueChangeSetEntry {
    private final ChangeLogSet.Entry changeSet;
    private final Reachable parent;
    private final BlueOrganization organization;
    private int checkoutCount;

    public ChangeSetResource(@Nonnull BlueOrganization organization, ChangeLogSet.Entry changeSet, Reachable parent) {
        this.organization = organization;
        this.changeSet = changeSet;
        this.parent = parent;
    }

    public BlueUser getAuthor() {
        return new UserImpl(this.organization, this.changeSet.getAuthor());
    }

    public String getTimestamp() {
        if (this.changeSet.getTimestamp() > 0L) {
            return AbstractRunImpl.DATE_FORMAT.format(Instant.ofEpochMilli(this.changeSet.getTimestamp()));
        }
        return null;
    }

    public String getUrl() {
        RepositoryBrowser browser = this.changeSet.getParent().getBrowser();
        if (browser != null) {
            try {
                URL url = browser.getChangeSetLink(this.changeSet);
                return url == null ? null : url.toExternalForm();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public String getCommitId() {
        return this.changeSet.getCommitId();
    }

    public String getMsg() {
        return this.changeSet.getMsg();
    }

    public Collection<String> getAffectedPaths() {
        return this.changeSet.getAffectedPaths();
    }

    @Nullable
    public Collection<BlueIssue> getIssues() {
        return BlueIssueFactory.resolve((ChangeLogSet.Entry)this.changeSet);
    }

    public Integer getCheckoutCount() {
        return this.checkoutCount;
    }

    public BlueChangeSetEntry setCheckoutCount(int checkoutCount) {
        this.checkoutCount = checkoutCount;
        return this;
    }

    public Link getLink() {
        return this.parent.getLink().rel(this.getCommitId());
    }
}

