/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.BlueTrendFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueTrend;
import io.jenkins.blueocean.rest.model.BlueTrendContainer;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlueTrendContainerImpl
extends BlueTrendContainer {
    private final BluePipeline pipeline;

    public BlueTrendContainerImpl(BluePipeline pipeline) {
        this.pipeline = pipeline;
    }

    public Link getLink() {
        return this.pipeline.getLink().rel("trends");
    }

    public BlueTrend get(final String name) {
        BlueTrend trend = (BlueTrend)Iterators.find(this.iterator(), (Predicate)new Predicate<BlueTrend>(){

            public boolean apply(@Nullable BlueTrend input) {
                return input != null && input.getId().equals(name);
            }
        }, null);
        if (trend == null) {
            throw new ServiceException.NotFoundException("not found");
        }
        return trend;
    }

    @Nonnull
    public Iterator<BlueTrend> iterator() {
        return BlueTrendFactory.getTrends((BluePipeline)this.pipeline, (Link)this.getLink()).iterator();
    }
}

