/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueTestResultFactory;
import io.jenkins.blueocean.rest.model.BlueTestResult;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class BlueTestResultContainerImpl
extends BlueTestResultContainer {
    protected final Run<?, ?> run;

    public BlueTestResultContainerImpl(Reachable parent, Run<?, ?> run) {
        super(parent);
        this.run = run;
    }

    protected BlueTestResultFactory.Result resolve() {
        return BlueTestResultFactory.resolve(this.run, (Reachable)this.parent);
    }

    public BlueTestResult get(String name) {
        BlueTestResultFactory.Result resolved = this.resolve();
        if (resolved.summary == null || resolved.results == null) {
            throw new ServiceException.NotFoundException("no tests");
        }
        BlueTestResult testResult = (BlueTestResult)Iterables.find((Iterable)resolved.results, input -> input != null && input.getId().equals(name), null);
        if (testResult == null) {
            throw new ServiceException.NotFoundException("not found");
        }
        return testResult;
    }

    @Nonnull
    public Iterator<BlueTestResult> iterator() {
        BlueTestResultFactory.Result resolved = this.resolve();
        if (resolved.summary == null || resolved.results == null) {
            throw new ServiceException.NotFoundException("no tests");
        }
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null) {
            String status = request.getParameter("status");
            String state = request.getParameter("state");
            String age = request.getParameter("age");
            return this.getBlueTestResultIterator(resolved.results, status, state, age);
        }
        return resolved.results.iterator();
    }

    @VisibleForTesting
    public Iterator<BlueTestResult> getBlueTestResultIterator(Iterable<BlueTestResult> results, String status, String state, String age) {
        if (StringUtils.isEmpty((String)status) && StringUtils.isEmpty((String)state) && StringUtils.isEmpty((String)age)) {
            return results.iterator();
        }
        Predicate predicate = Predicates.alwaysTrue();
        if (!StringUtils.isEmpty((String)status)) {
            predicate = Predicates.and((Predicate)predicate, BlueTestResultContainerImpl.filterByStatus(status));
        }
        if (!StringUtils.isEmpty((String)state)) {
            predicate = Predicates.and((Predicate)predicate, BlueTestResultContainerImpl.filterByState(state));
        }
        if (!StringUtils.isEmpty((String)age)) {
            predicate = Predicates.and((Predicate)predicate, BlueTestResultContainerImpl.filterByAge(age));
        }
        return Iterables.filter(results, (Predicate)predicate).iterator();
    }

    @VisibleForTesting
    public static Predicate<BlueTestResult> filterByAge(String age) {
        Integer _age;
        try {
            _age = Integer.parseInt(age);
        }
        catch (NumberFormatException ex) {
            throw new ServiceException.BadRequestException("age is not a number");
        }
        return new AgePredicate(_age);
    }

    @VisibleForTesting
    public static Predicate<BlueTestResult> filterByStatus(String status) {
        String[] statusAtoms = StringUtils.split((String)status, (char)',');
        Predicate predicate = Predicates.alwaysFalse();
        if (statusAtoms == null || statusAtoms.length == 0) {
            throw new ServiceException.BadRequestException("status not provided");
        }
        for (String statusString : statusAtoms) {
            StatusPredicate statusPredicate;
            try {
                statusPredicate = statusString.startsWith("!") ? Predicates.not((Predicate)new StatusPredicate(BlueTestResult.Status.valueOf((String)statusString.toUpperCase().substring(1)))) : new StatusPredicate(BlueTestResult.Status.valueOf((String)statusString.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException.BadRequestException("bad status " + status, (Throwable)e);
            }
            predicate = Predicates.or((Predicate)predicate, (Predicate)statusPredicate);
        }
        return predicate;
    }

    @VisibleForTesting
    public static Predicate<BlueTestResult> filterByState(String state) {
        String[] stateAtoms = StringUtils.split((String)state, (char)',');
        Predicate predicate = Predicates.alwaysFalse();
        if (stateAtoms == null || stateAtoms.length == 0) {
            throw new ServiceException.BadRequestException("state not provided");
        }
        for (String stateString : stateAtoms) {
            StatePredicate statePredicate;
            try {
                statePredicate = stateString.startsWith("!") ? Predicates.not((Predicate)new StatePredicate(BlueTestResult.State.valueOf((String)stateString.toUpperCase().substring(1)))) : new StatePredicate(BlueTestResult.State.valueOf((String)stateString.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException.BadRequestException("bad state " + state, (Throwable)e);
            }
            predicate = Predicates.or((Predicate)predicate, (Predicate)statePredicate);
        }
        return predicate;
    }

    static class AgePredicate
    implements Predicate<BlueTestResult> {
        private final Integer age;

        public AgePredicate(Integer age) {
            this.age = age;
        }

        public boolean apply(@Nullable BlueTestResult input) {
            if (input == null) {
                return false;
            }
            if (this.age > 0) {
                return input.getAge() >= this.age;
            }
            if (this.age < 0) {
                return input.getAge() <= Math.abs(this.age);
            }
            return input.getAge() == this.age.intValue();
        }
    }

    static class StatePredicate
    implements Predicate<BlueTestResult> {
        private final BlueTestResult.State state;

        StatePredicate(BlueTestResult.State state) {
            this.state = state;
        }

        public boolean apply(@Nullable BlueTestResult input) {
            return input != null && input.getTestState().equals((Object)this.state);
        }
    }

    static class StatusPredicate
    implements Predicate<BlueTestResult> {
        private final BlueTestResult.Status status;

        StatusPredicate(BlueTestResult.Status status) {
            this.status = status;
        }

        public boolean apply(@Nullable BlueTestResult input) {
            return input != null && input.getStatus().equals((Object)this.status);
        }
    }
}

