/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.UnprotectedRootAction;
import io.jenkins.blueocean.BlueOceanUI;
import io.jenkins.blueocean.BlueOceanUIProvider;
import io.jenkins.blueocean.auth.jwt.impl.JwtAuthenticationFilter;
import io.jenkins.blueocean.commons.BlueOceanConfigProperties;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class BlueOceanRootAction
implements UnprotectedRootAction,
StaplerProxy {
    private static final String URL_BASE = "blue";
    private final boolean enableJWT = BlueOceanConfigProperties.BLUEOCEAN_FEATURE_JWT_AUTHENTICATION;
    @Inject
    private BlueOceanUI app;

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_BASE;
    }

    public Object getTarget() {
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request.getOriginalRestOfPath().startsWith("/rest/")) {
            if (this.enableJWT && !JwtAuthenticationFilter.didRequestHaveValidatedJwtToken()) {
                throw new ServiceException.UnauthorizedException("Unauthorized: Jwt token verification failed, no valid authentication instance found");
            }
            Authentication a = Jenkins.getAuthentication();
            if (!Jenkins.getInstance().getACL().hasPermission(a, Jenkins.READ)) {
                throw new ServiceException.ForbiddenException("Forbidden");
            }
        } else {
            Jenkins.getInstance().checkPermission(Jenkins.READ);
        }
        Stapler.getCurrentResponse().setHeader("X-Blueocean-Refresher", Jenkins.SESSION_HASH);
        return this.app;
    }

    @Extension(ordinal=-9999.0)
    public static class BlueOceanUIProviderImpl
    extends BlueOceanUIProvider {
        public String getRootUrl() {
            return Jenkins.getInstance().getRootUrl();
        }

        @Nonnull
        public String getUrlBasePrefix() {
            return BlueOceanRootAction.URL_BASE;
        }

        @Nonnull
        public String getLandingPagePath() {
            BlueOrganization organization = OrganizationFactory.getInstance().getContainingOrg((ItemGroup)Jenkins.getInstance());
            String orgName = organization != null ? organization.getName() : "jenkins";
            return String.format("/organizations/%s/pipelines/", orgName);
        }
    }

    @Extension
    public static class ModuleImpl
    implements Module {
        public void configure(Binder binder) {
            binder.bind(BlueOceanUI.class).toInstance((Object)new BlueOceanUI());
        }
    }
}

