/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hudson.model.BuildableItem;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.service.embedded.rest.QueueItemImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;

public class QueueUtil {
    public static BlueQueueItem getQueuedItem(Queue.Item item, Job job) {
        for (BlueQueueItem qi : QueueUtil.getQueuedItems(job)) {
            if (!qi.getId().equalsIgnoreCase(Long.toString(item.getId()))) continue;
            return qi;
        }
        return null;
    }

    @Nullable
    public static <T extends Run> T getRun(@Nonnull Job job, final long queueId) {
        return (T)((Run)Iterables.find((Iterable)job.getBuilds(), (Predicate)new Predicate<Run>(){

            public boolean apply(@Nullable Run input) {
                return input != null && input.getQueueId() == queueId;
            }
        }, null));
    }

    public static List<BlueQueueItem> getQueuedItems(Job job) {
        Link pipelineLink = LinkResolver.resolveLink((Object)job);
        if (job instanceof BuildableItem) {
            BuildableItem task = (BuildableItem)job;
            List items = Jenkins.getInstance().getQueue().getItems((Queue.Task)task);
            ArrayList items2 = Lists.newArrayList();
            for (int i = 0; i < items.size(); ++i) {
                Link self = pipelineLink.rel("queue").rel(Long.toString(((Queue.Item)items.get(i)).getId()));
                items2.add(0, new QueueItemImpl((Queue.Item)items.get(i), job.getName(), items.size() == 1 ? job.getNextBuildNumber() : job.getNextBuildNumber() + i, self, pipelineLink));
            }
            return items2;
        }
        throw new ServiceException.UnexpectedErrorException("This pipeline is not buildable and therefore does not have a queue.");
    }

    private QueueUtil() {
    }
}

