/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.console.AnnotatedLargeText;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.service.embedded.rest.LogAppender;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.AcceptHeader;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.CharSpool;
import org.kohsuke.stapler.framework.io.LineEndNormalizingWriter;

public class LogResource {
    public static final long DEFAULT_LOG_THREASHOLD = 150L;
    private final AnnotatedLargeText logText;
    private final Reader appenderLogReader;

    public LogResource(AnnotatedLargeText log) {
        this(log, LogAppender.DEFAULT);
    }

    public LogResource(@Nonnull AnnotatedLargeText log, @Nonnull LogAppender logAppender) {
        this.logText = log;
        this.appenderLogReader = logAppender.getLog();
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp, @Header(value="Accept") AcceptHeader accept) {
        this.writeLog(req, rsp, accept);
    }

    private void writeLog(StaplerRequest req, StaplerResponse rsp, AcceptHeader accept) {
        try {
            String download = req.getParameter("download");
            if ("true".equalsIgnoreCase(download)) {
                rsp.setHeader("Content-Disposition", "attachment; filename=log.txt");
            }
            rsp.setContentType("text/plain;charset=UTF-8");
            rsp.setStatus(200);
            this.writeLogs(req, rsp);
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to get logText: " + e.getMessage(), (Throwable)e);
        }
    }

    private void writeLogs(StaplerRequest req, StaplerResponse rsp) throws IOException {
        long threshold = 153600L;
        String s = req.getParameter("thresholdInKB");
        if (s != null) {
            threshold = Long.parseLong(s) * 1024L;
        }
        long offset = req.getParameter("start") != null ? Long.parseLong(req.getParameter("start")) : (this.logText.length() > threshold ? this.logText.length() - threshold : 0L);
        CharSpool spool = new CharSpool();
        long r = this.logText.writeLogTo(offset, (Writer)spool);
        Writer w = this.createWriter(req, rsp, r - offset);
        spool.writeTo((Writer)new LineEndNormalizingWriter(w));
        if (!this.logText.isComplete()) {
            rsp.addHeader("X-More-Data", "true");
        } else {
            int text = this.appenderLogReader.read();
            while (text != -1) {
                w.write(text);
                ++r;
                text = this.appenderLogReader.read();
            }
        }
        rsp.addHeader("X-Text-Size", String.valueOf(r));
        w.close();
    }

    private Writer createWriter(StaplerRequest req, StaplerResponse rsp, long size) throws IOException {
        if (size > 4096L) {
            return rsp.getCompressedWriter((HttpServletRequest)req);
        }
        return rsp.getWriter();
    }
}

