/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueRunFactory;
import io.jenkins.blueocean.rest.factory.BlueTestResultFactory;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.Links;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueArtifactContainer;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Containers;
import io.jenkins.blueocean.rest.model.GenericResource;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.ArtifactContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.BlueTestResultContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.LogResource;
import io.jenkins.blueocean.service.embedded.rest.StoppableRun;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kohsuke.stapler.QueryParameter;

public class AbstractRunImpl<T extends Run>
extends BlueRun {
    protected final T run;
    protected final BlueOrganization org;
    protected final Reachable parent;

    public AbstractRunImpl(T run, Reachable parent) {
        this.run = run;
        this.parent = parent;
        this.org = OrganizationFactory.getInstance().getContainingOrg(run);
    }

    @Nonnull
    public Container<BlueChangeSetEntry> getChangeSet() {
        return Containers.empty((Link)this.getLink());
    }

    public String getOrganization() {
        return this.org.getName();
    }

    public String getId() {
        return this.run.getId();
    }

    public String getPipeline() {
        return this.run.getParent().getName();
    }

    public String getName() {
        String displayName;
        String defaultName = "#" + this.run.getNumber();
        return defaultName.equals(displayName = this.run.getDisplayName()) ? null : displayName;
    }

    public String getDescription() {
        return this.run.getDescription();
    }

    public Date getStartTime() {
        return new Date(this.run.getStartTimeInMillis());
    }

    public Date getEnQueueTime() {
        return new Date(this.run.getTimeInMillis());
    }

    public BlueRun.BlueRunState getStateObj() {
        if (!this.run.hasntStartedYet() && this.run.isLogUpdated()) {
            return BlueRun.BlueRunState.RUNNING;
        }
        if (!this.run.isLogUpdated()) {
            return BlueRun.BlueRunState.FINISHED;
        }
        return BlueRun.BlueRunState.RUNNING;
    }

    public BlueRun.BlueRunResult getResult() {
        if (this.getStateObj() == BlueRun.BlueRunState.RUNNING) {
            return BlueRun.BlueRunResult.UNKNOWN;
        }
        Result result = this.run.getResult();
        return result != null ? BlueRun.BlueRunResult.valueOf((String)result.toString()) : BlueRun.BlueRunResult.UNKNOWN;
    }

    public Date getEndTime() {
        if (!this.run.isBuilding()) {
            return new Date(this.run.getStartTimeInMillis() + this.run.getDuration());
        }
        return null;
    }

    public Long getDurationInMillis() {
        return this.run.getDuration();
    }

    public Long getEstimatedDurtionInMillis() {
        return this.run.getEstimatedDuration();
    }

    public String getRunSummary() {
        return this.run.getBuildStatusSummary().message;
    }

    public String getType() {
        return this.run.getClass().getSimpleName();
    }

    public Object getLog() {
        return new LogResource(this.run.getLogText());
    }

    public BlueRun replay() {
        return null;
    }

    public Collection<BlueRun.BlueCause> getCauses() {
        return BlueCauseImpl.getCauses(this.run);
    }

    public String getCauseOfBlockage() {
        return null;
    }

    public boolean isReplayable() {
        return false;
    }

    public BlueArtifactContainer getArtifacts() {
        return new ArtifactContainerImpl((Run)this.run, (Reachable)this);
    }

    public BluePipelineNodeContainer getNodes() {
        return null;
    }

    public BluePipelineStepContainer getSteps() {
        return null;
    }

    public BlueTestResultContainer getTests() {
        return new BlueTestResultContainerImpl(this, (Run<?, ?>)this.run);
    }

    public BlueTestSummary getTestSummary() {
        return BlueTestResultFactory.resolve(this.run, (Reachable)this).summary;
    }

    public Collection<BlueActionProxy> getActions() {
        return ActionProxiesImpl.getActionProxies(this.run.getAllActions(), (Reachable)this);
    }

    public static BlueRun getBlueRun(Run r, Reachable parent) {
        for (BlueRunFactory runFactory : BlueRunFactory.all()) {
            BlueRun blueRun = runFactory.getRun(r, parent);
            if (blueRun == null) continue;
            return blueRun;
        }
        return new AbstractRunImpl<Run>(r, parent);
    }

    public BlueRun stop(@QueryParameter(value="blocking") Boolean blocking, @QueryParameter(value="timeOutInSecs") Integer timeOutInSecs) {
        throw new ServiceException.NotImplementedException("Stop should be implemented on a subclass");
    }

    public String getArtifactsZipFile() {
        return "/" + this.run.getUrl() + "artifact/*zip*/archive.zip";
    }

    protected BlueRun stop(Boolean blocking, Integer timeOutInSecs, StoppableRun stoppableRun) {
        if (blocking == null) {
            blocking = false;
        }
        try {
            long start = System.currentTimeMillis();
            if (timeOutInSecs == null) {
                timeOutInSecs = 10;
            }
            if (timeOutInSecs < 0) {
                throw new ServiceException.BadRequestException("timeOutInSecs must be >= 0");
            }
            long timeOutInMillis = timeOutInSecs * 1000;
            long sleepingInterval = timeOutInMillis / 10L;
            do {
                if (this.isCompletedOrAborted()) {
                    return this;
                }
                stoppableRun.stop();
                if (this.isCompletedOrAborted()) {
                    return this;
                }
                Thread.sleep(sleepingInterval);
            } while (blocking.booleanValue() && System.currentTimeMillis() - start < timeOutInMillis);
        }
        catch (Exception e) {
            throw new ServiceException.UnexpectedErrorException(String.format("Failed to stop run %s: %s", this.run.getId(), e.getMessage()), (Throwable)e);
        }
        return this;
    }

    public Object getDynamic(String token) {
        for (Action a : this.run.getAllActions()) {
            if (!token.equals(a.getUrlName())) continue;
            return new GenericResource((Object)a);
        }
        return null;
    }

    public Link getLink() {
        if (this.parent == null) {
            return this.org.getLink().rel(String.format("pipelines/%s/runs/%s", this.run.getParent().getName(), this.getId()));
        }
        return this.parent.getLink().rel("runs/" + this.getId());
    }

    private boolean isCompletedOrAborted() {
        Result result = this.run.getResult();
        return result != null && (result == Result.ABORTED || result.isCompleteBuild());
    }

    public Links getLinks() {
        return super.getLinks().add("parent", this.parent.getLink());
    }

    public static class BlueCauseImpl
    extends BlueRun.BlueCause {
        private final Cause cause;

        BlueCauseImpl(Cause cause) {
            this.cause = cause;
        }

        public String getShortDescription() {
            return this.cause.getShortDescription();
        }

        public Object getCause() {
            return this.cause;
        }

        static Collection<BlueRun.BlueCause> getCauses(Run run) {
            CauseAction action = (CauseAction)run.getAction(CauseAction.class);
            if (action == null) {
                return null;
            }
            return BlueCauseImpl.getCauses(action.getCauses());
        }

        static Collection<BlueRun.BlueCause> getCauses(Collection<Cause> causes) {
            return Collections2.transform(causes, (Function)new Function<Cause, BlueRun.BlueCause>(){

                public BlueRun.BlueCause apply(@Nullable Cause input) {
                    return new BlueCauseImpl(input);
                }
            });
        }
    }
}

