/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.util;

import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class OrganizationUtil {
    private static final Pattern pattern = Pattern.compile("/blue/organizations/([^/]*)/");

    @CheckForNull
    public static String getOrganizationNameFromURL() {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        if (currentRequest == null) {
            return null;
        }
        String requestURI = currentRequest.getRequestURI();
        if (requestURI == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(requestURI);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @CheckForNull
    public static BlueOrganization getOrganization(@CheckForNull String orgName, boolean defaultToFirst) {
        Iterator iterator;
        OrganizationFactory orgFactory = OrganizationFactory.getInstance();
        BlueOrganization organization = null;
        if (orgName != null) {
            organization = orgFactory.get(orgName);
        }
        if (organization == null && defaultToFirst && (iterator = orgFactory.list().iterator()).hasNext()) {
            organization = (BlueOrganization)iterator.next();
        }
        return organization;
    }

    public static BlueOrganization getFirst() {
        return (BlueOrganization)OrganizationFactory.getInstance().list().iterator().next();
    }
}

