/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.model.User;
import hudson.util.AdaptedIterator;
import io.jenkins.blueocean.rest.ApiHead;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BlueUser;
import io.jenkins.blueocean.rest.model.BlueUserContainer;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Extension
public class UserContainerImpl
extends BlueUserContainer {
    private final Reachable parent;
    @Nullable
    private final BlueOrganization organization;

    public UserContainerImpl(@Nullable BlueOrganization organization, @Nonnull Reachable parent) {
        this.parent = parent;
        this.organization = organization;
    }

    public UserContainerImpl() {
        this.parent = null;
        this.organization = null;
    }

    public BlueUser get(String name) {
        User user = User.get((String)name, (boolean)false, (Map)ImmutableMap.of());
        if (user == null) {
            return null;
        }
        return new UserImpl(this.organization, user, (Reachable)this);
    }

    public Iterator<BlueUser> iterator() {
        return new AdaptedIterator<User, BlueUser>((Iterable)User.getAll()){

            protected BlueUser adapt(User item) {
                return new UserImpl(UserContainerImpl.this.organization, item, (Reachable)UserContainerImpl.this);
            }
        };
    }

    public Link getLink() {
        if (this.parent != null) {
            return this.parent.getLink().rel(this.getUrlName());
        }
        return ApiHead.INSTANCE().getLink().rel(this.getUrlName());
    }
}

