/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.service.embedded.rest.ContainerFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;

public class PipelineContainerImpl
extends BluePipelineContainer {
    @Nonnull
    private final ItemGroup itemGroup;
    private final Link self;
    private final BlueOrganization org;

    public PipelineContainerImpl() {
        this((ItemGroup)Jenkins.getInstance(), null);
    }

    public PipelineContainerImpl(ItemGroup itemGroup) {
        this(itemGroup, null);
    }

    public PipelineContainerImpl(ItemGroup itemGroup, Reachable parent) {
        this.itemGroup = itemGroup instanceof Jenkins ? new PermissionFilteredItemGroup((Jenkins)itemGroup) : itemGroup;
        this.org = OrganizationFactory.getInstance().getContainingOrg(itemGroup);
        this.self = parent != null ? parent.getLink().rel("pipelines") : this.org.getLink().rel("pipelines");
    }

    public Link getLink() {
        return this.self;
    }

    public BluePipeline get(String name) {
        Item item = this.itemGroup.getItem(name);
        if (item == null) {
            throw new ServiceException.NotFoundException(String.format("Pipeline %s not found", name));
        }
        return BluePipelineFactory.getPipelineInstance((Item)item, (Reachable)this);
    }

    public Iterator<BluePipeline> iterator() {
        return this.getPipelines(this.itemGroup.getItems());
    }

    public Iterator<BluePipeline> getPipelines(Collection<? extends Item> items) {
        items = ContainerFilter.filter(items);
        ArrayList<BluePipeline> pipelines = new ArrayList<BluePipeline>();
        for (Item item : items) {
            BluePipeline pipeline = BluePipelineFactory.getPipelineInstance((Item)item, (Reachable)this);
            if (pipeline == null) continue;
            pipelines.add(pipeline);
        }
        return pipelines.iterator();
    }

    static class PermissionFilteredItemGroup
    implements ItemGroup<TopLevelItem> {
        private final Jenkins jenkins;

        public PermissionFilteredItemGroup(Jenkins jenkins) {
            this.jenkins = jenkins;
        }

        public TopLevelItem getItem(String name) throws AccessDeniedException {
            return this.jenkins.getItem(name);
        }

        public Collection<TopLevelItem> getItems() {
            return Collections2.filter((Collection)this.jenkins.getItems(), (Predicate)new Predicate<TopLevelItem>(){

                public boolean apply(TopLevelItem input) {
                    return input.hasPermission(Item.READ);
                }
            });
        }

        public String getFullName() {
            throw new UnsupportedOperationException();
        }

        public String getFullDisplayName() {
            throw new UnsupportedOperationException();
        }

        public String getUrl() {
            throw new UnsupportedOperationException();
        }

        public String getUrlChildPrefix() {
            throw new UnsupportedOperationException();
        }

        public File getRootDirFor(TopLevelItem child) {
            throw new UnsupportedOperationException();
        }

        public void onRenamed(TopLevelItem item, String oldName, String newName) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void onDeleted(TopLevelItem item) throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        public File getRootDir() {
            throw new UnsupportedOperationException();
        }

        public void save() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

