/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.util.RunList;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.OmniSearch;
import io.jenkins.blueocean.rest.Query;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.pageable.Pageable;
import io.jenkins.blueocean.rest.pageable.Pageables;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.PipelineContainerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.lazy.LazyBuildMixIn;

@Extension
public class RunSearch
extends OmniSearch<BlueRun> {
    public String getType() {
        return "run";
    }

    public Pageable<BlueRun> search(Query q) {
        String pipeline = q.param("pipeline", false);
        boolean latestOnly = (Boolean)q.param("latestOnly", Boolean.class);
        if (pipeline != null) {
            TopLevelItem p = Jenkins.getActiveInstance().getItem(pipeline);
            if (latestOnly) {
                BlueRun r = this.getLatestRun((Job)p);
                if (r != null) {
                    return Pageables.wrap(Collections.singletonList(r));
                }
                Pageables.empty();
            }
            if (p instanceof Job) {
                return Pageables.wrap(RunSearch.findRuns((Job)p));
            }
            throw new ServiceException.BadRequestExpception(String.format("Pipeline %s not found", pipeline));
        }
        if (latestOnly) {
            return Pageables.empty();
        }
        return Pageables.wrap(RunSearch.findRuns(null));
    }

    public static Iterable<BlueRun> findRuns(Job job, final Link parent) {
        ArrayList<BlueRun> runs = new ArrayList<BlueRun>();
        Object pipelines = job != null ? ImmutableList.of((Object)job) : Jenkins.getActiveInstance().getItems(Job.class);
        Iterator iterator = pipelines.iterator();
        while (iterator.hasNext()) {
            Job p = (Job)iterator.next();
            RunList runList = p.getBuilds();
            for (Run r : runList) {
                runs.add(AbstractRunImpl.getBlueRun(r, new Reachable(){

                    public Link getLink() {
                        return parent;
                    }
                }));
            }
        }
        return runs;
    }

    public static Iterable<BlueRun> findRuns(Job job, Link parent, int start, int limit) {
        ArrayList<BlueRun> runs = new ArrayList<BlueRun>();
        Object pipelines = job != null ? ImmutableList.of((Object)job) : Jenkins.getInstance().getItems(Job.class);
        Iterator iterator = pipelines.iterator();
        while (iterator.hasNext()) {
            Iterator runIterator;
            Job p = (Job)iterator.next();
            if (job instanceof LazyBuildMixIn.LazyLoadingJob) {
                LazyBuildMixIn lazyLoadMixin = ((LazyBuildMixIn.LazyLoadingJob)job).getLazyBuildMixIn();
                runIterator = lazyLoadMixin.getRunMap().iterator();
            } else {
                runIterator = p.getBuilds().iterator();
            }
            runs.addAll(RunSearch.collectRuns(runIterator, parent, start, limit));
        }
        return runs;
    }

    private static List<BlueRun> collectRuns(Iterator<? extends Run> runIterator, final Link parent, int start, int limit) {
        ArrayList<BlueRun> runs = new ArrayList<BlueRun>();
        int skipCount = start;
        while (runIterator.hasNext()) {
            if (skipCount > 0) {
                runIterator.next();
                --skipCount;
            } else {
                runs.add(AbstractRunImpl.getBlueRun(runIterator.next(), new Reachable(){

                    public Link getLink() {
                        return parent;
                    }
                }));
            }
            if (runs.size() < limit) continue;
            return runs;
        }
        return runs;
    }

    public static Iterable<BlueRun> findRuns(Job pipeline) {
        return RunSearch.findRuns(pipeline, null);
    }

    private BlueRun getLatestRun(Job job) {
        Run r;
        if (job != null && (r = job.getLastBuild()) != null) {
            AbstractRunImpl.getBlueRun(r, (Reachable)new PipelineContainerImpl().get(job.getFullName()));
        }
        return null;
    }
}

