/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.Item;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.OmniSearch;
import io.jenkins.blueocean.rest.Query;
import io.jenkins.blueocean.rest.factory.OrganizationResolver;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.pageable.Pageable;
import io.jenkins.blueocean.rest.pageable.Pageables;
import io.jenkins.blueocean.service.embedded.rest.ContainerFilter;
import io.jenkins.blueocean.service.embedded.rest.PipelineContainerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class PipelineSearch
extends OmniSearch<BluePipeline> {
    private static final String EXCLUDED_FROM_FLATTENING_PARAM = "excludedFromFlattening";
    private static final String ORGANIZATION_PARAM = "organization";
    private static final Logger logger = LoggerFactory.getLogger(PipelineSearch.class);

    public String getType() {
        return "pipeline";
    }

    public Pageable<BluePipeline> search(Query q) {
        String s = q.param(EXCLUDED_FROM_FLATTENING_PARAM);
        ItemGroup org = this.org(q);
        ArrayList<Class> excludeList = new ArrayList<Class>();
        if (s != null) {
            for (String s1 : s.split(",")) {
                Class<?> c = null;
                try {
                    c = Class.forName(s1);
                }
                catch (ClassNotFoundException e) {
                    try {
                        Plugin p = Jenkins.getInstance().getPlugin("blueocean-pipeline-api-impl");
                        if (p != null) {
                            c = p.getWrapper().classLoader.loadClass(s1);
                        } else {
                            logger.error("blueocean-pipeline-api-impl plugin not found!");
                        }
                    }
                    catch (ClassNotFoundException e1) {
                        logger.error(e.getMessage(), (Throwable)e1);
                    }
                }
                if (c == null) continue;
                excludeList.add(c);
            }
        }
        Collection<Object> items = new ArrayList();
        if (!excludeList.isEmpty()) {
            for (Item item : this.getAllItems(org)) {
                if (this.exclude(item.getParent(), excludeList)) continue;
                items.add(item);
            }
        } else {
            items = this.getAllItems(org);
        }
        items = ContainerFilter.filter(items);
        final Iterator<BluePipeline> pipelineIterator = new PipelineContainerImpl().getPipelines(items);
        ArrayList<BluePipeline> pipelines = new ArrayList<BluePipeline>();
        String pipeline = q.param(this.getType());
        if (pipeline == null) {
            return Pageables.wrap((Iterable)new Iterable<BluePipeline>(){

                @Override
                public Iterator<BluePipeline> iterator() {
                    return pipelineIterator;
                }
            });
        }
        while (pipelineIterator.hasNext()) {
            BluePipeline p = pipelineIterator.next();
            if (!p.getName().equals(pipeline)) continue;
            pipelines.add(p);
        }
        return Pageables.wrap(pipelines);
    }

    private List<Item> getAllItems(ItemGroup org) {
        ArrayList<Item> r = new ArrayList<Item>();
        this.getAllItems(org, r);
        return r;
    }

    private void getAllItems(ItemGroup<?> org, List<Item> r) {
        for (Item i : org.getItems()) {
            r.add(i);
            if (!(i instanceof ItemGroup)) continue;
            this.getAllItems((ItemGroup)i, r);
        }
    }

    private ItemGroup org(Query q) {
        String org = q.param(ORGANIZATION_PARAM);
        if (org == null) {
            return Jenkins.getInstance();
        }
        ItemGroup group = OrganizationResolver.getItemGroup((String)org);
        if (group == null) {
            throw new ServiceException.BadRequestExpception(String.format("Organization %s not found. Query parameter %s value: %s is invalid. ", org, ORGANIZATION_PARAM, org));
        }
        return group;
    }

    private boolean exclude(ItemGroup item, List<Class> excludeList) {
        for (Class c : excludeList) {
            if (!c.isAssignableFrom(item.getClass())) continue;
            return true;
        }
        return false;
    }
}

